import request from '@/utils/request'

// 查询上图设备信息列表
export function listInfo(query) {
  return request({
    url: '/map/deviceInfo/list',
    method: 'get',
    params: query
  })
}

//获取所有上图设备信息
export function deviceInfoLists(query) {
  return request({
    url: '/map/deviceInfo/deviceInfoLists',
    method: 'get',
    params: query
  })
}

// 查询上图设备信息详细
export function getInfo(mapDeviceId) {
  return request({
    url: '/map/deviceInfo/' + mapDeviceId,
    method: 'get'
  })
}

// 新增上图设备信息
export function addInfo(data) {
  return request({
    url: '/map/deviceInfo',
    method: 'post',
    data: data
  })
}

// 修改上图设备信息
export function updateInfo(data) {
  return request({
    url: '/map/deviceInfo',
    method: 'put',
    data: data
  })
}

// 删除上图设备信息
export function delInfo(mapDeviceId) {
  return request({
    url: '/map/deviceInfo/' + mapDeviceId,
    method: 'delete'
  })
}

// 导出上图设备信息
export function exportInfo(query) {
  return request({
    url: '/map/deviceInfo/export',
    method: 'get',
    params: query
  })
}
