import request from '@/utils/request'

// 查询门禁人员信息列表
export function listInfo(query) {
  return request({
    url: '/entranceGuardPerson/info/list',
    method: 'get',
    params: query
  })
}

//二道门数据初始化
export function getEntranceGuardPersonInfo() {
  return request({
    url: '/entranceGuardPerson/info/getEntranceGuardPersonInfo',
    method: 'get'
  })
}

// 查询门禁人员信息详细
export function getInfo(entranceGuardPersonId) {
  return request({
    url: '/entranceGuardPerson/info/' + entranceGuardPersonId,
    method: 'get'
  })
}

// 新增门禁人员信息
export function addInfo(data) {
  return request({
    url: '/entranceGuardPerson/info',
    method: 'post',
    data: data
  })
}

// 修改门禁人员信息
export function updateInfo(data) {
  return request({
    url: '/entranceGuardPerson/info',
    method: 'put',
    data: data
  })
}

// 删除门禁人员信息
export function delInfo(entranceGuardPersonId) {
  return request({
    url: '/entranceGuardPerson/info/' + entranceGuardPersonId,
    method: 'delete'
  })
}

// 导出门禁人员信息
export function exportInfo(query) {
  return request({
    url: '/entranceGuardPerson/info/export',
    method: 'get',
    params: query
  })
}
