import request from '@/utils/request'

// 查询题库题目列表
export function listSubject(query) {
  return request({
    url: '/system/subject/list',
    method: 'get',
    params: query
  })
}

// 查询题库题目详细
export function getSubject(subjectId) {
  return request({
    url: '/system/subject/' + subjectId,
    method: 'get'
  })
}
// 新增题库题目
export function addSubject(data) {
  return request({
    url: '/system/subject',
    method: 'post',
    data: data
  })
}

// 修改题库题目
export function updateSubject(data) {
  return request({
    url: '/system/subject',
    method: 'put',
    data: data
  })
}

// 删除题库题目
export function delSubject(subjectId) {
  return request({
    url: '/system/subject/' + subjectId,
    method: 'delete'
  })
}

// 导出题库题目
export function exportSubject(query) {
  return request({
    url: '/system/subject/export',
    method: 'get',
    params: query
  })
}