import request from '@/utils/request'

// 查询特种设备台账列表
export function listSpecialDeviceRecord(query) {
  return request({
    url: '/deviceManagement/specialDeviceRecord/list',
    method: 'get',
    params: query
  })
}

// 查询特种设备台账详细
export function getSpecialDeviceRecord(id) {
  return request({
    url: '/deviceManagement/specialDeviceRecord/' + id,
    method: 'get'
  })
}

// 新增特种设备台账
export function addSpecialDeviceRecord(data) {
  return request({
    url: '/deviceManagement/specialDeviceRecord',
    method: 'post',
    data: data
  })
}

// 修改特种设备台账
export function updateSpecialDeviceRecord(data) {
  return request({
    url: '/deviceManagement/specialDeviceRecord',
    method: 'put',
    data: data
  })
}

// 删除特种设备台账
export function delSpecialDeviceRecord(id) {
  return request({
    url: '/deviceManagement/specialDeviceRecord/' + id,
    method: 'delete'
  })
}

// 导出特种设备台账
export function exportSpecialDeviceRecord(query) {
  return request({
    url: '/deviceManagement/specialDeviceRecord/export',
    method: 'get',
    params: query
  })
}