import request from '@/utils/request'

// 查询设备保养计划列表
export function listMaintainPlan(query) {
  return request({
    url: '/deviceManagement/maintainPlan/list',
    method: 'get',
    params: query
  })
}

// 查询设备保养计划详细
export function getMaintainPlan(id) {
  return request({
    url: '/deviceManagement/maintainPlan/' + id,
    method: 'get'
  })
}

// 新增设备保养计划
export function addMaintainPlan(data) {
  return request({
    url: '/deviceManagement/maintainPlan',
    method: 'post',
    data: data
  })
}

// 修改设备保养计划
export function updateMaintainPlan(data) {
  return request({
    url: '/deviceManagement/maintainPlan',
    method: 'put',
    data: data
  })
}

// 删除设备保养计划
export function delMaintainPlan(id) {
  return request({
    url: '/deviceManagement/maintainPlan/' + id,
    method: 'delete'
  })
}

// 导出设备保养计划
export function exportMaintainPlan(query) {
  return request({
    url: '/deviceManagement/maintainPlan/export',
    method: 'get',
    params: query
  })
}