import request from '@/utils/request'

// 查询设备信息管理列表
export function listDeviceInfo(query) {
  return request({
    url: '/deviceManagement/deviceInfo/list',
    method: 'get',
    params: query
  })
}
// 查询特种设备列表
export function listSpecial(query) {
  return request({
    url: '/deviceManagement/deviceInfo/listSpecial',
    method: 'get',
    params: query
  })
}

// 查询设备信息管理详细
export function getDeviceInfo(id) {
  return request({
    url: '/deviceManagement/deviceInfo/' + id,
    method: 'get'
  })
}

// 新增设备信息管理
export function addDeviceInfo(data) {
  return request({
    url: '/deviceManagement/deviceInfo',
    method: 'post',
    data: data
  })
}

// 修改设备信息管理
export function updateDeviceInfo(data) {
  return request({
    url: '/deviceManagement/deviceInfo',
    method: 'put',
    data: data
  })
}

// 删除设备信息管理
export function delDeviceInfo(id) {
  return request({
    url: '/deviceManagement/deviceInfo/' + id,
    method: 'delete'
  })
}

// 导出设备信息管理
export function exportDeviceInfo(query) {
  return request({
    url: '/deviceManagement/deviceInfo/export',
    method: 'get',
    params: query
  })
}

// 下载设备导入模板
export function importTemplate() {
  return request({
    url: '/deviceManagement/deviceInfo/importTemplate',
    method: 'get'
  })
}
