import request from '@/utils/request'

// 查询承包商及访客培训题库列表
export function listTopic(query) {
  return request({
    url: '/contractTrainTopic/list',
    method: 'get',
    params: query
  })
}
// 新增承包商及访客培训考试结果
export function setEsult(query) {
  return request({
    url: '/system/result/examination',
    method: 'get',
    params: query
  })
}

// 查询承包商及访客培训题库详细
export function getTopic(topicId) {
  return request({
    url: '/contractTrainTopic/' + topicId,
    method: 'get'
  })
}

// 新增承包商及访客培训题库
export function addTopic(data) {
  return request({
    url: '/contractTrainTopic',
    method: 'post',
    data: data
  })
}

// 修改承包商及访客培训题库
export function updateTopic(data) {
  return request({
    url: '/contractTrainTopic',
    method: 'put',
    data: data
  })
}

// 删除承包商及访客培训题库
export function delTopic(topicId) {
  return request({
    url: '/contractTrainTopic/' + topicId,
    method: 'delete'
  })
}

// 导出承包商及访客培训题库
export function exportTopic(query) {
  return request({
    url: '/contractTrainTopic/export',
    method: 'get',
    params: query
  })
}
