import request from '@/utils/request'

// 查询承包商及访客培训考试结果详情列表
export function listResult(query) {
  return request({
    url: '/system/result/list',
    method: 'get',
    params: query
  })
}

// 查询承包商及访客培训考试结果详情详细
export function getResult(resultId) {
  return request({
    url: '/system/result/' + resultId,
    method: 'get'
  })
}

// 新增承包商及访客培训考试结果详情
export function addResult(data) {
  return request({
    url: '/system/result',
    method: 'post',
    data: data
  })
}

// 修改承包商及访客培训考试结果详情
export function updateResult(data) {
  return request({
    url: '/system/result',
    method: 'put',
    data: data
  })
}

// 删除承包商及访客培训考试结果详情
export function delResult(resultId) {
  return request({
    url: '/system/result/' + resultId,
    method: 'delete'
  })
}

// 导出承包商及访客培训考试结果详情
export function exportResult(query) {
  return request({
    url: '/system/result/export',
    method: 'get',
    params: query
  })
}