import request from '@/utils/request'

// 查询承包商及访客培训列表
export function listCourse(query) {
  return request({
    url: '/contractTrain/list',
    method: 'get',
    params: query
  })
}

// 查询承包商及访客培训详细
export function getCourse(contractorCourseId) {
  return request({
    url: '/contractTrain/' + contractorCourseId,
    method: 'get'
  })
}

// 新增承包商及访客培训
export function addCourse(data) {
  return request({
    url: '/contractTrain',
    method: 'post',
    data: data
  })
}

// 修改承包商及访客培训
export function updateCourse(data) {
  return request({
    url: '/contractTrain',
    method: 'put',
    data: data
  })
}

// 删除承包商及访客培训
export function delCourse(contractorCourseId) {
  return request({
    url: '/contractTrain/' + contractorCourseId,
    method: 'delete'
  })
}

// 导出承包商及访客培训
export function exportCourse(query) {
  return request({
    url: '/contractTrain/export',
    method: 'get',
    params: query
  })
}
