package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TSpecialWorkPermit;
import com.zehong.system.domain.TSpecialWorkPermitSign;
import com.zehong.system.domain.TWorkPermit;
import com.zehong.system.mapper.TSpecialWorkPermitMapper;
import com.zehong.system.mapper.TSpecialWorkPermitSignMapper;
import com.zehong.system.mapper.TWorkPermitMapper;
import com.zehong.system.service.ITWorkPermitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 作业许可证Service业务层处理
 * 
 * @author zehong
 * @date 2022-08-18
 */
@Service
public class TWorkPermitServiceImpl implements ITWorkPermitService 
{
    @Autowired
    private TWorkPermitMapper tWorkPermitMapper;
    @Autowired
    private TSpecialWorkPermitMapper tSpecialWorkPermitMapper;
    @Autowired
    private TSpecialWorkPermitSignMapper tSpecialWorkPermitSignMapper;

    /**
     * 查询作业许可证
     * 
     * @param workPermitId 作业许可证ID
     * @return 作业许可证
     */
    @Override
    public TWorkPermit selectTWorkPermitById(Long workPermitId)
    {
        return tWorkPermitMapper.selectTWorkPermitById(workPermitId);
    }

    /**
     * 查询作业许可证列表
     * 
     * @param tWorkPermit 作业许可证
     * @return 作业许可证
     */
    @Override
    public List<TWorkPermit> selectTWorkPermitList(TWorkPermit tWorkPermit)
    {
        return tWorkPermitMapper.selectTWorkPermitList(tWorkPermit);
    }

    /**
     * 新增作业许可证
     * 
     * @param tWorkPermit 作业许可证
     * @return 结果
     */
    @Override
    public int insertTWorkPermit(TWorkPermit tWorkPermit)
    {
        tWorkPermit.setCreateTime(DateUtils.getNowDate());
        return tWorkPermitMapper.insertTWorkPermit(tWorkPermit);
    }

    /**
     * 修改作业许可证
     * 
     * @param tWorkPermit 作业许可证
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int judgeSignUpdateTWorkPermit(TWorkPermit tWorkPermit)
    {
        boolean flag = true;
        TSpecialWorkPermit tSpecialWorkPermit = new TSpecialWorkPermit();
        tSpecialWorkPermit.setWorkPermitId(tWorkPermit.getWorkPermitId());
        List<TSpecialWorkPermit> specialWorkPermits = tSpecialWorkPermitMapper.selectTSpecialWorkPermitList(tSpecialWorkPermit);
        if(null != specialWorkPermits){
            for(TSpecialWorkPermit special : specialWorkPermits){
                TSpecialWorkPermitSign tSpecialWorkPermitSign = new TSpecialWorkPermitSign();
                tSpecialWorkPermitSign.setPermitId(special.getSpecialWorkPermitId());
                List<TSpecialWorkPermitSign> signs = tSpecialWorkPermitSignMapper.selectTSpecialWorkPermitSignList(tSpecialWorkPermitSign);
                if(null != signs){
                    for(TSpecialWorkPermitSign sign : signs){
                        if(sign.getSignName() == "" || null == sign.getSignName()){
                            flag = false;
                        }
                    }
                }
            }
        }
        if (flag){
            tWorkPermit.setUpdateTime(DateUtils.getNowDate());
            return tWorkPermitMapper.updateTWorkPermit(tWorkPermit);
        }
        return 0;

    }

    @Override
    public int updateTWorkPermit(TWorkPermit tWorkPermit)
    {
        tWorkPermit.setUpdateTime(DateUtils.getNowDate());
        return tWorkPermitMapper.updateTWorkPermit(tWorkPermit);
    }

    /**
     * 批量删除作业许可证
     * 
     * @param workPermitIds 需要删除的作业许可证ID
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int deleteTWorkPermitByIds(Long[] workPermitIds)
    {
        List<Long> specialIds = new ArrayList<>();
        List<Long> signIds = new ArrayList<>();
        for(Long workPermitId : workPermitIds){
            TSpecialWorkPermit tSpecialWorkPermit = new TSpecialWorkPermit();
            tSpecialWorkPermit.setWorkPermitId(workPermitId);
            List<TSpecialWorkPermit> specialWorkPermits = tSpecialWorkPermitMapper.selectTSpecialWorkPermitList(tSpecialWorkPermit);
            if(null != specialWorkPermits){
                for(TSpecialWorkPermit special : specialWorkPermits){
                    specialIds.add(special.getSpecialWorkPermitId());
                    TSpecialWorkPermitSign tSpecialWorkPermitSign = new TSpecialWorkPermitSign();
                    tSpecialWorkPermitSign.setPermitId(special.getSpecialWorkPermitId());
                    List<TSpecialWorkPermitSign> signs = tSpecialWorkPermitSignMapper.selectTSpecialWorkPermitSignList(tSpecialWorkPermitSign);
                    if(null != signs){
                        for(TSpecialWorkPermitSign sign : signs){
                            signIds.add(sign.getSignId());
                        }
                    }
                }
            }
        }
        if(specialIds.size() >0){
            tSpecialWorkPermitMapper.deleteTSpecialWorkPermitByIds(specialIds.toArray(new Long[specialIds.size()]));

        }
        if(signIds.size() >0){
            tSpecialWorkPermitSignMapper.deleteTSpecialWorkPermitSignByIds(signIds.toArray(new Long[signIds.size()]));
        }
        return tWorkPermitMapper.deleteTWorkPermitByIds(workPermitIds);
    }

    /**
     * 删除作业许可证信息
     * 
     * @param workPermitId 作业许可证ID
     * @return 结果
     */
    @Override
    public int deleteTWorkPermitById(Long workPermitId)
    {
        return tWorkPermitMapper.deleteTWorkPermitById(workPermitId);
    }

    /**
     * 根据登录用户查询作业单
     * @param tWorkPermit
     * @return
     */
    @Override
    public List<TWorkPermit> selectTWorkPermitListByLoginUser(TWorkPermit tWorkPermit){
        return tWorkPermitMapper.selectTWorkPermitListByLoginUser(tWorkPermit);
    }

    @Override
    public int selectUpdate(Long workPermitId){

        Integer a = tWorkPermitMapper.selectSign(workPermitId);
        if(a==0){
            TWorkPermit t = tWorkPermitMapper.selectTWorkPermitById(workPermitId);
            t.setApplyStatus("2");
            return tWorkPermitMapper.updateTWorkPermit(t);
        }else {
            return 1;
        }
    }
}
