package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.vo.PlanPostVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTrainPlanMapper;
import com.zehong.system.domain.TTrainPlan;
import com.zehong.system.service.ITTrainPlanService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 培训计划Service业务层处理
 * 
 * @author zehong
 * @date 2022-09-17
 */
@Service
public class TTrainPlanServiceImpl implements ITTrainPlanService 
{
    @Autowired
    private TTrainPlanMapper tTrainPlanMapper;

    /**
     * 查询培训计划
     * 
     * @param planId 培训计划ID
     * @return 培训计划
     */
    @Override
    public TTrainPlan selectTTrainPlanById(Long planId)
    {
        return tTrainPlanMapper.selectTTrainPlanById(planId);
    }

    /**
     * 查询培训计划列表
     * 
     * @param tTrainPlan 培训计划
     * @return 培训计划
     */
    @Override
    public List<TTrainPlan> selectTTrainPlanList(TTrainPlan tTrainPlan)
    {
        List<TTrainPlan> list = tTrainPlanMapper.selectTTrainPlanList(tTrainPlan);
        for(TTrainPlan t : list){
            List<PlanPostVo> mapList = tTrainPlanMapper.selectTrainPostByPlanId(t.getPlanId());
            t.setPostList(mapList);
        }
        return list;
    }
    public List<TTrainPlan> selectTTrainPlanDownList(){
        return tTrainPlanMapper.selectTTrainPlanList(null);
    }
    /**
     * 新增培训计划
     * 
     * @param tTrainPlan 培训计划
     * @return 结果
     */
    @Override
    @Transactional
    public Long insertTTrainPlan(TTrainPlan tTrainPlan,List<Map<String,Object>> list)
    {
        tTrainPlan.setCreateTime(DateUtils.getNowDate());
        int a = tTrainPlanMapper.insertTTrainPlan(tTrainPlan);
        tTrainPlanMapper.insetsPlanPost(tTrainPlan.getPlanId(),list);
        return tTrainPlan.getPlanId();
    }

    /**
     * 修改培训计划
     * 
     * @param tTrainPlan 培训计划
     * @return 结果
     */
    @Override
    @Transactional
    public int updateTTrainPlan(TTrainPlan tTrainPlan,List<Map<String,Object>> list)
    {
        int a = tTrainPlanMapper.updateTTrainPlan(tTrainPlan);
        tTrainPlanMapper.deletePlanPost(tTrainPlan.getPlanId());
        tTrainPlanMapper.insetsPlanPost(tTrainPlan.getPlanId(),list);
        return a;
    }

    /**
     * 批量删除培训计划
     * 
     * @param planIds 需要删除的培训计划ID
     * @return 结果
     */
    @Override
    public int deleteTTrainPlanByIds(Long[] planIds)
    {
        return tTrainPlanMapper.deleteTTrainPlanByIds(planIds);
    }

    /**
     * 删除培训计划信息
     * 
     * @param planId 培训计划ID
     * @return 结果
     */
    @Override
    public int deleteTTrainPlanById(Long planId)
    {
        int a = tTrainPlanMapper.deleteTTrainPlanById(planId);
        tTrainPlanMapper.deletePlanPost(planId);
        return a;
    }
}
