package com.zehong.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TBankSubject;
import com.zehong.system.domain.TTrainCourse;
import com.zehong.system.domain.TTrainCourseTopic;
import com.zehong.system.domain.vo.BatchTopicVo;
import com.zehong.system.mapper.TBankSubjectMapper;
import com.zehong.system.mapper.TTrainCourseMapper;
import com.zehong.system.mapper.TTrainCourseTopicMapper;
import com.zehong.system.service.ITTrainCourseTopicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 培训课程题库Service业务层处理
 * 
 * @author zehong
 * @date 2022-09-19
 */
@Service
public class TTrainCourseTopicServiceImpl implements ITTrainCourseTopicService 
{
    @Autowired
    private TTrainCourseTopicMapper tTrainCourseTopicMapper;
    @Autowired
    private TTrainCourseMapper tTrainCourseMapper;
    @Resource
    private TBankSubjectMapper tBankSubjectMapper;

    /**
     * 查询培训课程题库
     * 
     * @param topicId 培训课程题库ID
     * @return 培训课程题库
     */
    @Override
    public TTrainCourseTopic selectTTrainCourseTopicById(Long topicId)
    {
        return tTrainCourseTopicMapper.selectTTrainCourseTopicById(topicId);
    }

    /**
     * 查询培训课程题库列表
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 培训课程题库
     */
    @Override
    public List<TTrainCourseTopic> selectTTrainCourseTopicList(TTrainCourseTopic tTrainCourseTopic)
    {
        return tTrainCourseTopicMapper.selectTTrainCourseTopicList(tTrainCourseTopic);
    }
    @Override
    public List<TTrainCourseTopic> selectCourseTopicList(Long courseId)
    {
        return tTrainCourseTopicMapper.selectCourseTopicList(courseId);
    }

    /**
     * 新增培训课程题库
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 结果
     */
    @Override
    @Transactional
    public int insertTTrainCourseTopic(TTrainCourseTopic tTrainCourseTopic)
    {
        tTrainCourseTopic.setCreateTime(DateUtils.getNowDate());
        TTrainCourse course = tTrainCourseMapper.selectTTrainCourseById(tTrainCourseTopic.getCourseId());
        if(course!=null){
            course.setTopicNum(course.getTopicNum()+1);
            tTrainCourseMapper.updateTTrainCourse(course);
        }
        return tTrainCourseTopicMapper.insertTTrainCourseTopic(tTrainCourseTopic);
    }

    /**
     * 修改培训课程题库
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 结果
     */
    @Override
    public int updateTTrainCourseTopic(TTrainCourseTopic tTrainCourseTopic)
    {
        return tTrainCourseTopicMapper.updateTTrainCourseTopic(tTrainCourseTopic);
    }

    /**
     * 批量删除培训课程题库
     * 
     * @param topicIds 需要删除的培训课程题库ID
     * @return 结果
     */
    @Override
    public int deleteTTrainCourseTopicByIds(Long[] topicIds)
    {
        return tTrainCourseTopicMapper.deleteTTrainCourseTopicByIds(topicIds);
    }

    /**
     * 删除培训课程题库信息
     * 
     * @param topicId 培训课程题库ID
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteTTrainCourseTopicById(Long topicId)
    {
        TTrainCourseTopic topic = tTrainCourseTopicMapper.selectTTrainCourseTopicById(topicId);
        if(topic==null){
            return 0;
        }
        TTrainCourse course = tTrainCourseMapper.selectTTrainCourseById(topic.getCourseId());
        if(course!=null){
            course.setTopicNum(course.getTopicNum()-1);
            tTrainCourseMapper.updateTTrainCourse(course);
        }
        return tTrainCourseTopicMapper.deleteTTrainCourseTopicById(topicId);
    }

    /**
     * 题库批量导入试题
     * @param batchTopicVo 试题实体
     * @return int
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int bachAddTopic(BatchTopicVo batchTopicVo){
        if(CollectionUtil.isEmpty(batchTopicVo.getTopicInfos()) || StringUtils.isEmpty(String.valueOf(batchTopicVo.getCourseId()))){
            return 0;
        }
        List<TTrainCourseTopic> topics = new ArrayList<>();
        int count = 0;
        for(BatchTopicVo.TopicInfos topic : batchTopicVo.getTopicInfos()){
            //获取题库试题
            TBankSubject tBankSubject = new TBankSubject();
            tBankSubject.setBankId(topic.getBankId());
            List<TBankSubject> bankSubjects = tBankSubjectMapper.selectTBankSubjectList(tBankSubject);
            //获取随机试题
            Collections.shuffle(bankSubjects);
            for(int i = 0;i<topic.getQuan();i++){
                TTrainCourseTopic courseTopic = new TTrainCourseTopic();
                courseTopic.setCourseId(batchTopicVo.getCourseId());
                courseTopic.setTopicTitle(bankSubjects.get(i).getTopicTitle());
                courseTopic.setTopicOption(bankSubjects.get(i).getTopicOption());
                courseTopic.setAnswer(bankSubjects.get(i).getAnswer());
                courseTopic.setCreateTime(new Date());
                topics.add(courseTopic);
            }
            count += topic.getQuan();
        }
        //批量新增试题
        tTrainCourseTopicMapper.batchInsertTTrainCourseTopic(topics);
        //更新试题数量
        TTrainCourse course = tTrainCourseMapper.selectTTrainCourseById(batchTopicVo.getCourseId());
        course.setTopicNum(course.getTopicNum() + count);
        return tTrainCourseMapper.updateTTrainCourse(course);
    }
}
