package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTrainCourseBankMapper;
import com.zehong.system.domain.TTrainCourseBank;
import com.zehong.system.service.ITTrainCourseBankService;

/**
 * bankService业务层处理
 * 
 * @author zehong
 * @date 2022-12-14
 */
@Service
public class TTrainCourseBankServiceImpl implements ITTrainCourseBankService 
{
    @Autowired
    private TTrainCourseBankMapper tTrainCourseBankMapper;

    /**
     * 查询bank
     * 
     * @param bankId bankID
     * @return bank
     */
    @Override
    public TTrainCourseBank selectTTrainCourseBankById(Long bankId)
    {
        return tTrainCourseBankMapper.selectTTrainCourseBankById(bankId);
    }

    /**
     * 查询bank列表
     * 
     * @param tTrainCourseBank bank
     * @return bank
     */
    @Override
    public List<TTrainCourseBank> selectTTrainCourseBankList(TTrainCourseBank tTrainCourseBank)
    {
        return tTrainCourseBankMapper.selectTTrainCourseBankList(tTrainCourseBank);
    }

    /**
     * 新增bank
     * 
     * @param tTrainCourseBank bank
     * @return 结果
     */
    @Override
    public int insertTTrainCourseBank(TTrainCourseBank tTrainCourseBank)
    {
        tTrainCourseBank.setCreateTime(DateUtils.getNowDate());
        return tTrainCourseBankMapper.insertTTrainCourseBank(tTrainCourseBank);
    }

    /**
     * 修改bank
     * 
     * @param tTrainCourseBank bank
     * @return 结果
     */
    @Override
    public int updateTTrainCourseBank(TTrainCourseBank tTrainCourseBank)
    {
        tTrainCourseBank.setUpdateTime(DateUtils.getNowDate());
        return tTrainCourseBankMapper.updateTTrainCourseBank(tTrainCourseBank);
    }

    /**
     * 批量删除bank
     * 
     * @param bankIds 需要删除的bankID
     * @return 结果
     */
    @Override
    public int deleteTTrainCourseBankByIds(Long[] bankIds)
    {
        return tTrainCourseBankMapper.deleteTTrainCourseBankByIds(bankIds);
    }

    /**
     * 删除bank信息
     * 
     * @param bankId bankID
     * @return 结果
     */
    @Override
    public int deleteTTrainCourseBankById(Long bankId)
    {
        return tTrainCourseBankMapper.deleteTTrainCourseBankById(bankId);
    }
}
