package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.zehong.common.core.domain.entity.SysDept;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.THiddenTroubleWork;
import com.zehong.system.mapper.SysDeptMapper;
import com.zehong.system.mapper.THiddenTroubleWorkMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TStaningBookMapper;
import com.zehong.system.domain.TStaningBook;
import com.zehong.system.service.ITStaningBookService;

/**
 * 隐患台账Service业务层处理
 * 
 * @author zehong
 * @date 2022-07-09
 */
@Service
public class TStaningBookServiceImpl implements ITStaningBookService 
{
    @Autowired
    private TStaningBookMapper tStaningBookMapper;
    @Autowired
    private THiddenTroubleWorkMapper tHiddenTroubleWorkMapper;
    @Autowired
    private SysDeptMapper deptMapper;

    /**
     * 查询隐患台账
     * 
     * @param bookId 隐患台账ID
     * @return 隐患台账
     */
    @Override
    public TStaningBook selectTStaningBookById(Long bookId)
    {
        return tStaningBookMapper.selectTStaningBookById(bookId);
    }

    /**
     * 查询隐患台账列表
     * 
     * @param tStaningBook 隐患台账
     * @return 隐患台账
     */
    @Override
    public List<TStaningBook> selectTStaningBookList(TStaningBook tStaningBook,Long deptId)
    {
        List<Long> oneList = new ArrayList<>();
        oneList.add(deptId);
        List<Long> deptIds = selectDeptIds(new ArrayList<>(),oneList);
        tStaningBook.setDeptList(deptIds);
        List<TStaningBook> list = tStaningBookMapper.selectTStaningBookList(tStaningBook);
        return  list;
    }
    public List<Long> selectDeptIds(List<Long> list,List<Long> deptIds){
        List<Long> resultlist = deptMapper.selectDeptByParentId(deptIds);
        if(resultlist.size()==0){
            return list;
        }
        list.addAll(resultlist);
        return selectDeptIds(list,resultlist);
    }
    /**
     * 新增隐患台账
     * 
     * @param tStaningBook 隐患台账
     * @return 结果
     */
    @Override
    public int insertTStaningBook(TStaningBook tStaningBook)
    {
        tStaningBook.setCreateTime(DateUtils.getNowDate());
        return tStaningBookMapper.insertTStaningBook(tStaningBook);
    }

    /**
     * 修改隐患台账
     * 
     * @param tStaningBook 隐患台账
     * @return 结果
     */
    @Override
    public int updateTStaningBook(TStaningBook tStaningBook)
    {
        return tStaningBookMapper.updateTStaningBook(tStaningBook);
    }

    /**
     * 批量删除隐患台账
     * 
     * @param bookIds 需要删除的隐患台账ID
     * @return 结果
     */
    @Override
    public int deleteTStaningBookByIds(Long[] bookIds)
    {
        return tStaningBookMapper.deleteTStaningBookByIds(bookIds);
    }

    /**
     * 删除隐患台账信息
     * 
     * @param bookId 隐患台账ID
     * @return 结果
     */
    @Override
    public int deleteTStaningBookById(Long bookId)
    {
        return tStaningBookMapper.deleteTStaningBookById(bookId);
    }

    @Override
    public Map statics(String type) {
        return tStaningBookMapper.statics(type);
    }
}
