package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TStaff;
import com.zehong.system.domain.form.TStaffForm;
import com.zehong.system.domain.vo.TStaffVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TStaffMapper;
import com.zehong.system.service.ITStaffService;

/**
 * 员工信息管理Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-17
 */
@Service
public class TStaffServiceImpl implements ITStaffService 
{
    @Autowired
    private TStaffMapper tStaffMapper;

    /**
     * 查询员工信息管理
     * 
     * @param staffId 员工信息管理ID
     * @return 员工信息管理
     */
    @Override
    public TStaffVo selectTStaffById(Long staffId)
    {
        return tStaffMapper.selectTStaffById(staffId);
    }

    /**
     * 查询员工信息管理列表
     * 
     * @param tStaff 员工信息管理
     * @return 员工信息管理
     */
    @Override
    public List<TStaffVo> selectTStaffList(TStaffForm tStaff)
    {
        return tStaffMapper.selectTStaffList(tStaff);
    }

    /**
     * 新增员工信息管理
     * 
     * @param tStaff 员工信息管理
     * @return 结果
     */
    @Override
    public int insertTStaff(TStaff tStaff)
    {
        String staffCode = tStaffMapper.getStaffCode();
        tStaff.setStaffCode(staffCode);
        tStaff.setCreateTime(DateUtils.getNowDate());
        return tStaffMapper.insertTStaff(tStaff);
    }

    /**
     * 修改员工信息管理
     * 
     * @param tStaff 员工信息管理
     * @return 结果
     */
    @Override
    public int updateTStaff(TStaff tStaff)
    {
        tStaff.setUpdateTime(DateUtils.getNowDate());
        return tStaffMapper.updateTStaff(tStaff);
    }

    /**
     * 批量删除员工信息管理
     * 
     * @param staffIds 需要删除的员工信息管理ID
     * @return 结果
     */
    @Override
    public int deleteTStaffByIds(Long[] staffIds)
    {
        return tStaffMapper.deleteTStaffByIds(staffIds);
    }

    /**
     * 删除员工信息管理信息
     * 
     * @param staffId 员工信息管理ID
     * @return 结果
     */
    @Override
    public int deleteTStaffById(Long staffId)
    {
        return tStaffMapper.deleteTStaffById(staffId);
    }
}
