package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.vo.TSpecialDeviceRecordVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSpecialDeviceRecordMapper;
import com.zehong.system.domain.TSpecialDeviceRecord;
import com.zehong.system.service.ITSpecialDeviceRecordService;

/**
 * 特种设备台账Service业务层处理
 * 
 * @author zehong
 * @date 2022-07-02
 */
@Service
public class TSpecialDeviceRecordServiceImpl implements ITSpecialDeviceRecordService 
{
    @Autowired
    private TSpecialDeviceRecordMapper tSpecialDeviceRecordMapper;

    /**
     * 查询特种设备台账
     * 
     * @param id 特种设备台账ID
     * @return 特种设备台账
     */
    @Override
    public TSpecialDeviceRecordVo selectTSpecialDeviceRecordById(Long id)
    {
        return tSpecialDeviceRecordMapper.selectTSpecialDeviceRecordById(id);
    }

    /**
     * 查询特种设备台账列表
     * 
     * @param tSpecialDeviceRecord 特种设备台账
     * @return 特种设备台账
     */
    @Override
    public List<TSpecialDeviceRecordVo> selectTSpecialDeviceRecordList(TSpecialDeviceRecord tSpecialDeviceRecord)
    {
        return tSpecialDeviceRecordMapper.selectTSpecialDeviceRecordList(tSpecialDeviceRecord);
    }

    /**
     * 新增特种设备台账
     * 
     * @param tSpecialDeviceRecord 特种设备台账
     * @return 结果
     */
    @Override
    public int insertTSpecialDeviceRecord(TSpecialDeviceRecord tSpecialDeviceRecord)
    {
        tSpecialDeviceRecord.setCreateTime(DateUtils.getNowDate());
        return tSpecialDeviceRecordMapper.insertTSpecialDeviceRecord(tSpecialDeviceRecord);
    }

    /**
     * 修改特种设备台账
     * 
     * @param tSpecialDeviceRecord 特种设备台账
     * @return 结果
     */
    @Override
    public int updateTSpecialDeviceRecord(TSpecialDeviceRecord tSpecialDeviceRecord)
    {
        return tSpecialDeviceRecordMapper.updateTSpecialDeviceRecord(tSpecialDeviceRecord);
    }

    /**
     * 批量删除特种设备台账
     * 
     * @param ids 需要删除的特种设备台账ID
     * @return 结果
     */
    @Override
    public int deleteTSpecialDeviceRecordByIds(Long[] ids)
    {
        return tSpecialDeviceRecordMapper.deleteTSpecialDeviceRecordByIds(ids);
    }

    /**
     * 删除特种设备台账信息
     * 
     * @param id 特种设备台账ID
     * @return 结果
     */
    @Override
    public int deleteTSpecialDeviceRecordById(Long id)
    {
        return tSpecialDeviceRecordMapper.deleteTSpecialDeviceRecordById(id);
    }
}
