package com.zehong.system.service.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSafetyCommitmentAnnouncementMapper;
import com.zehong.system.domain.TSafetyCommitmentAnnouncement;
import com.zehong.system.service.ITSafetyCommitmentAnnouncementService;

/**
 * 安全承诺公告Service业务层处理
 * 
 * @author zehong
 * @date 2022-12-21
 */
@Service
public class TSafetyCommitmentAnnouncementServiceImpl implements ITSafetyCommitmentAnnouncementService 
{
    @Autowired
    private TSafetyCommitmentAnnouncementMapper tSafetyCommitmentAnnouncementMapper;

    /**
     * 查询安全承诺公告
     * 
     * @param id 安全承诺公告ID
     * @return 安全承诺公告
     */
    @Override
    public TSafetyCommitmentAnnouncement selectTSafetyCommitmentAnnouncementById(Long id)
    {
        return tSafetyCommitmentAnnouncementMapper.selectTSafetyCommitmentAnnouncementById(id);
    }

    /**
     * 查询安全承诺公告列表
     * 
     * @param tSafetyCommitmentAnnouncement 安全承诺公告
     * @return 安全承诺公告
     */
    @Override
    public List<TSafetyCommitmentAnnouncement> selectTSafetyCommitmentAnnouncementList(TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement)
    {
        return tSafetyCommitmentAnnouncementMapper.selectTSafetyCommitmentAnnouncementList(tSafetyCommitmentAnnouncement);
    }

    /**
     * 新增安全承诺公告
     * 
     * @param tSafetyCommitmentAnnouncement 安全承诺公告
     * @return 结果
     */
    @Override
    public int insertTSafetyCommitmentAnnouncement(TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement)
    {
        return tSafetyCommitmentAnnouncementMapper.insertTSafetyCommitmentAnnouncement(tSafetyCommitmentAnnouncement);
    }

    /**
     * 修改安全承诺公告
     * 
     * @param tSafetyCommitmentAnnouncement 安全承诺公告
     * @return 结果
     */
    @Override
    public int updateTSafetyCommitmentAnnouncement(TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement)
    {
        return tSafetyCommitmentAnnouncementMapper.updateTSafetyCommitmentAnnouncement(tSafetyCommitmentAnnouncement);
    }

    /**
     * 批量删除安全承诺公告
     * 
     * @param ids 需要删除的安全承诺公告ID
     * @return 结果
     */
    @Override
    public int deleteTSafetyCommitmentAnnouncementByIds(Long[] ids)
    {
        return tSafetyCommitmentAnnouncementMapper.deleteTSafetyCommitmentAnnouncementByIds(ids);
    }

    /**
     * 删除安全承诺公告信息
     * 
     * @param id 安全承诺公告ID
     * @return 结果
     */
    @Override
    public int deleteTSafetyCommitmentAnnouncementById(Long id)
    {
        return tSafetyCommitmentAnnouncementMapper.deleteTSafetyCommitmentAnnouncementById(id);
    }
}
