package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TPlanInfo;
import com.zehong.system.mapper.TPlanInfoMapper;
import com.zehong.system.service.ITPlanInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 应急处置方案Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-01
 */
@Service
public class TPlanInfoServiceImpl implements ITPlanInfoService
{
    @Autowired
    private TPlanInfoMapper tPlanInfoMapper;

    /**
     * 查询应急处置方案
     * 
     * @param planId 应急处置方案ID
     * @return 应急处置方案
     */
    @Override
    public TPlanInfo selectTPlanInfoById(Long planId)
    {
        return tPlanInfoMapper.selectTPlanInfoById(planId);
    }

    /**
     * 查询应急处置方案列表
     * 
     * @param tPlanInfo 应急处置方案
     * @return 应急处置方案
     */
    @Override
    public List<TPlanInfo> selectTPlanInfoList(TPlanInfo tPlanInfo)
    {
        return tPlanInfoMapper.selectTPlanInfoList(tPlanInfo);
    }

    /**
     * 新增应急处置方案
     * 
     * @param tPlanInfo 应急处置方案
     * @return 结果
     */
    @Override
    public int insertTPlanInfo(TPlanInfo tPlanInfo)
    {
        tPlanInfo.setCreateTime(DateUtils.getNowDate());
        return tPlanInfoMapper.insertTPlanInfo(tPlanInfo);
    }

    /**
     * 修改应急处置方案
     * 
     * @param tPlanInfo 应急处置方案
     * @return 结果
     */
    @Override
    public int updateTPlanInfo(TPlanInfo tPlanInfo)
    {
        tPlanInfo.setUpdateTime(DateUtils.getNowDate());
        return tPlanInfoMapper.updateTPlanInfo(tPlanInfo);
    }

    /**
     * 批量删除应急处置方案
     * 
     * @param planIds 需要删除的应急处置方案ID
     * @return 结果
     */
    @Override
    public int deleteTPlanInfoByIds(Long[] planIds)
    {
        return tPlanInfoMapper.deleteTPlanInfoByIds(planIds);
    }

    /**
     * 删除应急处置方案信息
     * 
     * @param planId 应急处置方案ID
     * @return 结果
     */
    @Override
    public int deleteTPlanInfoById(Long planId)
    {
        return tPlanInfoMapper.deleteTPlanInfoById(planId);
    }
}
