package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TNfcRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TNfcSettingMapper;
import com.zehong.system.domain.TNfcSetting;
import com.zehong.system.service.ITNfcSettingService;
import org.springframework.transaction.annotation.Transactional;

/**
 * settingService业务层处理
 *
 * @author zehong
 * @date 2022-10-17
 */
@Service
public class TNfcSettingServiceImpl implements ITNfcSettingService
{
    @Autowired
    private TNfcSettingMapper tNfcSettingMapper;

    /**
     * 查询setting
     *
     * @param nfcId settingID
     * @return setting
     */
    @Override
    public TNfcSetting selectTNfcSettingById(Long nfcId)
    {
        return tNfcSettingMapper.selectTNfcSettingById(nfcId);
    }

    /**
     * 根据nfc查询
     * @param nfcNum
     * @return
     */
    @Override
    public TNfcSetting getInfoByNfcNum(String nfcNum)
    {
        return tNfcSettingMapper.getInfoByNfcNum(nfcNum);
    }

    /**
     * 查询setting列表
     *
     * @param tNfcSetting setting
     * @return setting
     */
    @Override
    public List<TNfcSetting> selectTNfcSettingList(TNfcSetting tNfcSetting)
    {
        return tNfcSettingMapper.selectTNfcSettingList(tNfcSetting);
    }

    /**
     * 新增setting
     *
     * @param tNfcSetting setting
     * @return 结果
     */
    @Override
    public int insertTNfcSetting(TNfcSetting tNfcSetting)
    {
        tNfcSetting.setCreateTime(DateUtils.getNowDate());
        return tNfcSettingMapper.insertTNfcSetting(tNfcSetting);
    }

    /**
     * 修改setting
     *
     * @param tNfcSetting setting
     * @return 结果
     */
    @Override
    @Transactional
    public int updateTNfcSetting(TNfcSetting tNfcSetting)
    {
        if (tNfcSetting.getNfcNum()==null||tNfcSetting.getNfcNum().equals("")){
            int a = tNfcSettingMapper.updateTNfcSetting(tNfcSetting);
            return a;
        }
        TNfcSetting ts = tNfcSettingMapper.getInfoByNfcNum(tNfcSetting.getNfcNum());
        if(ts!=null&&ts.getNfcId()!=tNfcSetting.getNfcId()){
            ts.setNfcNum("");
            tNfcSettingMapper.updateTNfcSetting(ts);
        }
        int a = tNfcSettingMapper.updateTNfcSetting(tNfcSetting);
        return a;
    }

    /**
     * 批量删除setting
     *
     * @param nfcIds 需要删除的settingID
     * @return 结果
     */
    @Override
    public int deleteTNfcSettingByIds(Long[] nfcIds)
    {
        return tNfcSettingMapper.deleteTNfcSettingByIds(nfcIds);
    }

    /**
     * 删除setting信息
     *
     * @param nfcId settingID
     * @return 结果
     */
    @Override
    public int deleteTNfcSettingById(Long nfcId)
    {
        return tNfcSettingMapper.deleteTNfcSettingById(nfcId);
    }

    /**
     * 巡检打卡查询列表
     * @param tNfcSetting
     * @return
     */
    @Override
    public List<TNfcRecord> punchClockList(TNfcSetting tNfcSetting) {
        return tNfcSettingMapper.punchClockList(tNfcSetting);
    }

    /**
     * 巡检打卡详细信息
     * @param recordId
     * @return
     */
    @Override
    public TNfcRecord getPunchClockList(Long recordId) {
        return tNfcSettingMapper.getPunchClockList(recordId);
    }
}
