package com.zehong.system.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TNfcRecordMapper;
import com.zehong.system.domain.TNfcRecord;
import com.zehong.system.service.ITNfcRecordService;

/**
 * nfc巡检记录idService业务层处理
 * 
 * @author zehong
 * @date 2022-10-18
 */
@Service
public class TNfcRecordServiceImpl implements ITNfcRecordService 
{
    @Autowired
    private TNfcRecordMapper tNfcRecordMapper;

    /**
     * 查询nfc巡检记录id
     * 
     * @param recordId nfc巡检记录idID
     * @return nfc巡检记录id
     */
    @Override
    public TNfcRecord selectTNfcRecordById(Long recordId)
    {
        return tNfcRecordMapper.selectTNfcRecordById(recordId);
    }

    /**
     * 查询nfc巡检记录id列表
     * 
     * @param tNfcRecord nfc巡检记录id
     * @return nfc巡检记录id
     */
    @Override
    public List<TNfcRecord> selectTNfcRecordList(TNfcRecord tNfcRecord)
    {
        return tNfcRecordMapper.selectTNfcRecordList(tNfcRecord);
    }

    /**
     * 新增nfc巡检记录id
     * 
     * @param tNfcRecord nfc巡检记录id
     * @return 结果
     */
    @Override
    public int insertTNfcRecord(TNfcRecord tNfcRecord)
    {
        tNfcRecord.setCreateTime(DateUtils.getNowDate());
        return tNfcRecordMapper.insertTNfcRecord(tNfcRecord);
    }

    /**
     * 修改nfc巡检记录id
     * 
     * @param tNfcRecord nfc巡检记录id
     * @return 结果
     */
    @Override
    public int updateTNfcRecord(TNfcRecord tNfcRecord)
    {
        return tNfcRecordMapper.updateTNfcRecord(tNfcRecord);
    }

    /**
     * 批量删除nfc巡检记录id
     * 
     * @param recordIds 需要删除的nfc巡检记录idID
     * @return 结果
     */
    @Override
    public int deleteTNfcRecordByIds(Long[] recordIds)
    {
        return tNfcRecordMapper.deleteTNfcRecordByIds(recordIds);
    }

    /**
     * 删除nfc巡检记录id信息
     * 
     * @param recordId nfc巡检记录idID
     * @return 结果
     */
    @Override
    public int deleteTNfcRecordById(Long recordId)
    {
        return tNfcRecordMapper.deleteTNfcRecordById(recordId);
    }
}
