package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TMaterialInfoMapper;
import com.zehong.system.domain.TMaterialInfo;
import com.zehong.system.service.ITMaterialInfoService;

/**
 * 应急物资管理Service业务层处理
 * 
 * @author zehong
 * @date 2022-07-01
 */
@Service
public class TMaterialInfoServiceImpl implements ITMaterialInfoService 
{
    @Autowired
    private TMaterialInfoMapper tMaterialInfoMapper;

    /**
     * 查询应急物资管理
     * 
     * @param id 应急物资管理ID
     * @return 应急物资管理
     */
    @Override
    public TMaterialInfo selectTMaterialInfoById(Long id)
    {
        return tMaterialInfoMapper.selectTMaterialInfoById(id);
    }

    /**
     * 查询应急物资管理列表
     * 
     * @param tMaterialInfo 应急物资管理
     * @return 应急物资管理
     */
    @Override
    public List<TMaterialInfo> selectTMaterialInfoList(TMaterialInfo tMaterialInfo)
    {
        return tMaterialInfoMapper.selectTMaterialInfoList(tMaterialInfo);
    }

    /**
     * 新增应急物资管理
     * 
     * @param tMaterialInfo 应急物资管理
     * @return 结果
     */
    @Override
    public int insertTMaterialInfo(TMaterialInfo tMaterialInfo)
    {
        tMaterialInfo.setCreateTime(DateUtils.getNowDate());
        return tMaterialInfoMapper.insertTMaterialInfo(tMaterialInfo);
    }

    /**
     * 修改应急物资管理
     * 
     * @param tMaterialInfo 应急物资管理
     * @return 结果
     */
    @Override
    public int updateTMaterialInfo(TMaterialInfo tMaterialInfo)
    {
        tMaterialInfo.setUpdateTime(DateUtils.getNowDate());
        return tMaterialInfoMapper.updateTMaterialInfo(tMaterialInfo);
    }

    /**
     * 批量删除应急物资管理
     * 
     * @param ids 需要删除的应急物资管理ID
     * @return 结果
     */
    @Override
    public int deleteTMaterialInfoByIds(Long[] ids)
    {
        return tMaterialInfoMapper.deleteTMaterialInfoByIds(ids);
    }

    /**
     * 删除应急物资管理信息
     * 
     * @param id 应急物资管理ID
     * @return 结果
     */
    @Override
    public int deleteTMaterialInfoById(Long id)
    {
        return tMaterialInfoMapper.deleteTMaterialInfoById(id);
    }
}
