package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TInspectWorkInfo;
import com.zehong.system.mapper.TInspectWorkInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInspectWorkPointRecordeMapper;
import com.zehong.system.domain.TInspectWorkPointRecorde;
import com.zehong.system.service.ITInspectWorkPointRecordeService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 巡检点记录信息Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-21
 */
@Service
public class TInspectWorkPointRecordeServiceImpl implements ITInspectWorkPointRecordeService 
{
    @Autowired
    private TInspectWorkPointRecordeMapper tInspectWorkPointRecordeMapper;
    @Autowired
    private TInspectWorkInfoMapper tInspectWorkInfoMapper;

    /**
     * 查询巡检点记录信息
     * 
     * @param pointId 巡检点记录信息ID
     * @return 巡检点记录信息
     */
    @Override
    public TInspectWorkPointRecorde selectTInspectWorkPointRecordeById(Long pointId)
    {
        return tInspectWorkPointRecordeMapper.selectTInspectWorkPointRecordeById(pointId);
    }

    /**
     * 查询巡检点记录信息列表
     * 
     * @param tInspectWorkPointRecorde 巡检点记录信息
     * @return 巡检点记录信息
     */
    @Override
    public List<TInspectWorkPointRecorde> selectTInspectWorkPointRecordeList(TInspectWorkPointRecorde tInspectWorkPointRecorde)
    {
        return tInspectWorkPointRecordeMapper.selectTInspectWorkPointRecordeList(tInspectWorkPointRecorde);
    }

    /**
     * 新增巡检点记录信息
     * 
     * @param tInspectWorkPointRecorde 巡检点记录信息
     * @return 结果
     */
    @Override
    public int insertTInspectWorkPointRecorde(TInspectWorkPointRecorde tInspectWorkPointRecorde)
    {
        tInspectWorkPointRecorde.setCreateTime(DateUtils.getNowDate());
        return tInspectWorkPointRecordeMapper.insertTInspectWorkPointRecorde(tInspectWorkPointRecorde);
    }

    /**
     * 修改巡检点记录信息
     * 
     * @param tInspectWorkPointRecorde 巡检点记录信息
     * @return 结果
     */
    @Override
    @Transactional
    public int updateTInspectWorkPointRecorde(TInspectWorkPointRecorde tInspectWorkPointRecorde)
    {
        tInspectWorkPointRecorde.setUpdateTime(DateUtils.getNowDate());
        tInspectWorkPointRecorde.setPointStatus("1");
        tInspectWorkPointRecorde.setPunchTime(new Date());
        List<Map<String,Object>> mapList = (List<Map<String,Object>>) JSON.parse(tInspectWorkPointRecorde.getPatrolDetail());
        for(Map<String,Object> map: mapList){
            if((Integer)map.get("paramType")==1){
                Integer testingNum = Integer.parseInt((String) map.get("testingNum"));
                Integer paramNum1 = Integer.parseInt((String) map.get("paramNum1"));
                Integer paramNum2 = Integer.parseInt((String) map.get("paramNum2"));
                if(testingNum<paramNum1||testingNum>paramNum2){
                    tInspectWorkPointRecorde.setIsException("1");
                }
            }else {
                Integer testingNum = (Integer) map.get("testingNum");
                Integer paramNum1 = (Integer) map.get("paramNum1");
                if(testingNum!=paramNum1){
                    tInspectWorkPointRecorde.setIsException("1");
                }
            }
        }

        int a = tInspectWorkPointRecordeMapper.updateTInspectWorkPointRecorde(tInspectWorkPointRecorde);
        TInspectWorkInfo workInfo = tInspectWorkInfoMapper.selectTInspectWorkInfoById(tInspectWorkPointRecorde.getWorkId());
        workInfo.setInspectSuccessNum(workInfo.getInspectSuccessNum()+1);
        tInspectWorkInfoMapper.updateTInspectWorkInfo(workInfo);
        return a;
    }

    /**
     * 批量删除巡检点记录信息
     * 
     * @param pointIds 需要删除的巡检点记录信息ID
     * @return 结果
     */
    @Override
    public int deleteTInspectWorkPointRecordeByIds(Long[] pointIds)
    {
        return tInspectWorkPointRecordeMapper.deleteTInspectWorkPointRecordeByIds(pointIds);
    }

    /**
     * 删除巡检点记录信息信息
     * 
     * @param pointId 巡检点记录信息ID
     * @return 结果
     */
    @Override
    public int deleteTInspectWorkPointRecordeById(Long pointId)
    {
        return tInspectWorkPointRecordeMapper.deleteTInspectWorkPointRecordeById(pointId);
    }
}
