package com.zehong.system.service.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.zehong.common.utils.DateUtils;

import com.zehong.system.domain.THiddenTroubleAssessment;
import com.zehong.system.domain.TStaningBook;
import com.zehong.system.mapper.THiddenTroubleAssessmentMapper;
import com.zehong.system.mapper.TStaningBookMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.THiddenTroubleWorkMapper;
import com.zehong.system.domain.THiddenTroubleWork;
import com.zehong.system.service.ITHiddenTroubleWorkService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 隐患排查任务Service业务层处理
 * 
 * @author zehong
 * @date 2022-07-11
 */
@Service
public class THiddenTroubleWorkServiceImpl implements ITHiddenTroubleWorkService 
{
    @Autowired
    private THiddenTroubleWorkMapper tHiddenTroubleWorkMapper;
    @Autowired
    private TStaningBookMapper tStaningBookMapper;
    @Autowired
    private THiddenTroubleAssessmentMapper tHiddenTroubleAssessmentMapper;
    private static Logger logger = LoggerFactory.getLogger(THiddenTroubleWorkServiceImpl.class);

    /**
     * 查询隐患排查任务
     * 
     * @param workId 隐患排查任务ID
     * @return 隐患排查任务
     */
    @Override
    public THiddenTroubleWork selectTHiddenTroubleWorkById(Long workId)
    {
        return tHiddenTroubleWorkMapper.selectTHiddenTroubleWorkById(workId);
    }

    /**
     * 查询隐患排查任务列表
     * 
     * @param tHiddenTroubleWork 隐患排查任务
     * @return 隐患排查任务
     */
    @Override
    public List<THiddenTroubleWork> selectTHiddenTroubleWorkList(THiddenTroubleWork tHiddenTroubleWork)
    {
        List<THiddenTroubleWork> list = tHiddenTroubleWorkMapper.selectTHiddenTroubleWorkList(tHiddenTroubleWork);
        if(tHiddenTroubleWork.getParentId()==0){
            for(THiddenTroubleWork w : list){
                THiddenTroubleWork tw = new THiddenTroubleWork();
                tw.setParentId(w.getWorkId());
                tw.setLimits(1);
                List<THiddenTroubleWork> list2 = tHiddenTroubleWorkMapper.selectTHiddenTroubleWorkList(tw);
                if(list2.size()>0){
                    w.setChildren(list2);
                }
            }
        }
        return list;
    }

    /**
     * app接口
     * @param tHiddenTroubleWork
     * @return
     */
    @Override
    public List<THiddenTroubleWork> selectTHiddenTroubleWorkListApp(THiddenTroubleWork tHiddenTroubleWork)
    {
        List<THiddenTroubleWork> list = tHiddenTroubleWorkMapper.selectTHiddenTroubleWorkListApp(tHiddenTroubleWork);
        return list;
    }
    /**
     * 新增隐患排查任务
     * 
     * @param tHiddenTroubleWork 隐患排查任务
     * @return 结果
     */
    @Override
    public int insertTHiddenTroubleWork(THiddenTroubleWork tHiddenTroubleWork)
    {
        tHiddenTroubleWork.setCreateTime(DateUtils.getNowDate());
        int a = tHiddenTroubleWorkMapper.insertTHiddenTroubleWork(tHiddenTroubleWork);
        if(tHiddenTroubleWork.getWorkCycle()==1){
            String[] ids =  tHiddenTroubleWork.getContent().split(",");
            tHiddenTroubleAssessmentMapper.inserts(tHiddenTroubleWork.getWorkId(),ids);
        }
        return a;
    }

    /**
     * 修改隐患排查任务
     * 
     * @param tHiddenTroubleWork 隐患排查任务
     * @return 结果
     */
    @Override
    public int updateTHiddenTroubleWork(THiddenTroubleWork tHiddenTroubleWork)
    {
        return tHiddenTroubleWorkMapper.updateTHiddenTroubleWork(tHiddenTroubleWork);
    }

    /**
     * 批量删除隐患排查任务
     * 
     * @param workIds 需要删除的隐患排查任务ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenTroubleWorkByIds(Long[] workIds)
    {
        return tHiddenTroubleWorkMapper.deleteTHiddenTroubleWorkByIds(workIds);
    }

    /**
     * 删除隐患排查任务信息
     * 
     * @param workId 隐患排查任务ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenTroubleWorkById(Long workId)
    {
        return tHiddenTroubleWorkMapper.deleteTHiddenTroubleWorkById(workId);
    }

    @Override
    @Transactional
    public void hiddenTroubleWorkTiming(){
        Date d = new Date();

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date begin = d;
        Date end = d;
        try {
            begin = dateFormat2.parse(dateFormat.format(d)+" 00:00:00") ;
            end = dateFormat2.parse(dateFormat.format(d)+" 23:59:59") ;
        }catch (Exception e){
            new Exception(e.getMessage());
        }

        //每天任务
        THiddenTroubleWork tw = new THiddenTroubleWork();
        tw.setParentId(0L);
        tw.setWorkCycle(2);
        List<THiddenTroubleWork> list1= tHiddenTroubleWorkMapper.selectTHiddenTroubleWorkList(tw);
        for(THiddenTroubleWork work:list1){
            work.setParentId(work.getWorkId());
            work.setWorkBeginTime(begin);
            work.setWorkEndTime(end);
            addHiddenTroubleWork(work);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        if(c.get(Calendar.DAY_OF_WEEK)==2){
            //每周任务
            tw.setWorkCycle(3);
            List<THiddenTroubleWork> list2= tHiddenTroubleWorkMapper.selectTHiddenTroubleWorkList(tw);
            for(THiddenTroubleWork work:list2){
                work.setParentId(work.getWorkId());
                work.setWorkBeginTime(begin);
                work.setWorkEndTime(end);
                addHiddenTroubleWork(work);
            }
        }
        if(c.get(Calendar.DATE)==1){
            //每月任务
            tw.setWorkCycle(4);
            List<THiddenTroubleWork> list3= tHiddenTroubleWorkMapper.selectTHiddenTroubleWorkList(tw);
            for(THiddenTroubleWork work:list3){
                work.setParentId(work.getWorkId());
                work.setWorkBeginTime(begin);
                work.setWorkEndTime(end);

                addHiddenTroubleWork(work);
            }
            int month = c.get(Calendar.MONTH) + 1;
            if(month%3==1){
                //每季度任务
                tw.setWorkCycle(5);
                List<THiddenTroubleWork> list4= tHiddenTroubleWorkMapper.selectTHiddenTroubleWorkList(tw);
                for(THiddenTroubleWork work:list4){
                    work.setParentId(work.getWorkId());
                    work.setWorkBeginTime(begin);
                    work.setWorkEndTime(end);
                    addHiddenTroubleWork(work);
                }
            }
        }
    }

    /**
     * 添加新任务
     */
    public void addHiddenTroubleWork(THiddenTroubleWork work){
        SimpleDateFormat format = new SimpleDateFormat("MM-dd");
        Date d = new Date();
        String data = format.format(d);
        work.setWorkName(work.getWorkName()+data);
        work.setWorkId(null);
        work.setWorkStep(0);
        work.setCreateTime(d);
        if(work.getBookId()!=null){
//            TStaningBook b = tStaningBookMapper.selectTStaningBookById(work.getBookId());
//            //如果隐患存在，并绑定的任务已完成则生成新新任务，否则不生成
//            if(b!=null&&b.getWorkId()!=null){
//                THiddenTroubleWork w = tHiddenTroubleWorkMapper.selectTHiddenTroubleWorkById(b.getWorkId());
//                if(w.getWorkStep()==4){
//                    int a = tHiddenTroubleWorkMapper.insertTHiddenTroubleWork(work);
//                    b.setWorkId(work.getWorkId());
//                    tStaningBookMapper.updateTStaningBook(b);
//                }else{
//                    logger.info("===================任务进行中生成新排查任务失败");
//                }
//            }else {
//                int a = tHiddenTroubleWorkMapper.insertTHiddenTroubleWork(work);
//                if(b!=null){
//                    b.setWorkId(work.getWorkId());
//                    tStaningBookMapper.updateTStaningBook(b);
//                }
//            }
        }else {
            tHiddenTroubleWorkMapper.insertTHiddenTroubleWork(work);
            String[] ids =  work.getContent().split(",");
            tHiddenTroubleAssessmentMapper.inserts(work.getWorkId(),ids);
        }
    }
}
