package com.zehong.system.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEntranceGuardPersonInfoMapper;
import com.zehong.system.domain.TEntranceGuardPersonInfo;
import com.zehong.system.service.ITEntranceGuardPersonInfoService;

/**
 * 门禁人员信息Service业务层处理
 * 
 * @author zehong
 * @date 2022-11-02
 */
@Service
public class TEntranceGuardPersonInfoServiceImpl implements ITEntranceGuardPersonInfoService 
{
    @Autowired
    private TEntranceGuardPersonInfoMapper tEntranceGuardPersonInfoMapper;

    /**
     * 查询门禁人员信息
     * 
     * @param entranceGuardPersonId 门禁人员信息ID
     * @return 门禁人员信息
     */
    @Override
    public TEntranceGuardPersonInfo selectTEntranceGuardPersonInfoById(Long entranceGuardPersonId)
    {
        return tEntranceGuardPersonInfoMapper.selectTEntranceGuardPersonInfoById(entranceGuardPersonId);
    }

    /**
     * 查询门禁人员信息列表
     * 
     * @param tEntranceGuardPersonInfo 门禁人员信息
     * @return 门禁人员信息
     */
    @Override
    public List<TEntranceGuardPersonInfo> selectTEntranceGuardPersonInfoList(TEntranceGuardPersonInfo tEntranceGuardPersonInfo)
    {
        return tEntranceGuardPersonInfoMapper.selectTEntranceGuardPersonInfoList(tEntranceGuardPersonInfo);
    }

    /**
     * 新增门禁人员信息
     * 
     * @param tEntranceGuardPersonInfo 门禁人员信息
     * @return 结果
     */
    @Override
    public int insertTEntranceGuardPersonInfo(TEntranceGuardPersonInfo tEntranceGuardPersonInfo)
    {
        tEntranceGuardPersonInfo.setCreateTime(DateUtils.getNowDate());
        return tEntranceGuardPersonInfoMapper.insertTEntranceGuardPersonInfo(tEntranceGuardPersonInfo);
    }

    /**
     * 修改门禁人员信息
     * 
     * @param tEntranceGuardPersonInfo 门禁人员信息
     * @return 结果
     */
    @Override
    public int updateTEntranceGuardPersonInfo(TEntranceGuardPersonInfo tEntranceGuardPersonInfo)
    {
        tEntranceGuardPersonInfo.setUpdateTime(DateUtils.getNowDate());
        return tEntranceGuardPersonInfoMapper.updateTEntranceGuardPersonInfo(tEntranceGuardPersonInfo);
    }

    /**
     * 批量删除门禁人员信息
     * 
     * @param entranceGuardPersonIds 需要删除的门禁人员信息ID
     * @return 结果
     */
    @Override
    public int deleteTEntranceGuardPersonInfoByIds(Long[] entranceGuardPersonIds)
    {
        return tEntranceGuardPersonInfoMapper.deleteTEntranceGuardPersonInfoByIds(entranceGuardPersonIds);
    }

    /**
     * 删除门禁人员信息信息
     * 
     * @param entranceGuardPersonId 门禁人员信息ID
     * @return 结果
     */
    @Override
    public int deleteTEntranceGuardPersonInfoById(Long entranceGuardPersonId)
    {
        return tEntranceGuardPersonInfoMapper.deleteTEntranceGuardPersonInfoById(entranceGuardPersonId);
    }

    /**
     * 二道门人员信息初始化
     */
    @Override
    public Map<String,Object> getEntranceGuardPersonInfo(){
        Map<String,Object> result = new HashMap<>(16);
        //出入人数统计
        List<Map<String,String>> actionCount = tEntranceGuardPersonInfoMapper.statisticsPersonByActionType();
        for(Map map : actionCount){
            if("0".equals(map.get("actionType"))){
                result.put("importCount",map.get("counts"));
            }
            if("1".equals(map.get("actionType"))){
                result.put("exportCount",map.get("counts"));
            }
        }
        //在场人数统计
        result.put("stayInCount",tEntranceGuardPersonInfoMapper.statisticsStayInPersons());
        //出入场最新数据
        List<TEntranceGuardPersonInfo> lastImportAndExportData = tEntranceGuardPersonInfoMapper.lastImportAndExportData();
        for(TEntranceGuardPersonInfo tEntranceGuardPersonInfo : lastImportAndExportData){
            if("0".equals(tEntranceGuardPersonInfo.getActionType())){
                result.put("lastImportData",tEntranceGuardPersonInfo);
            }
            if("1".equals(tEntranceGuardPersonInfo.getActionType())){
                result.put("lastExportData",tEntranceGuardPersonInfo);
            }
        }
        return result;

    }
}
