package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEnterpriseSystemMapper;
import com.zehong.system.domain.TEnterpriseSystem;
import com.zehong.system.service.ITEnterpriseSystemService;

/**
 * 企业制度管理Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-21
 */
@Service
public class TEnterpriseSystemServiceImpl implements ITEnterpriseSystemService 
{
    @Autowired
    private TEnterpriseSystemMapper tEnterpriseSystemMapper;

    /**
     * 查询企业制度管理
     * 
     * @param systemId 企业制度管理ID
     * @return 企业制度管理
     */
    @Override
    public TEnterpriseSystem selectTEnterpriseSystemById(Long systemId)
    {
        return tEnterpriseSystemMapper.selectTEnterpriseSystemById(systemId);
    }

    /**
     * 查询企业制度管理列表
     * 
     * @param tEnterpriseSystem 企业制度管理
     * @return 企业制度管理
     */
    @Override
    public List<TEnterpriseSystem> selectTEnterpriseSystemList(TEnterpriseSystem tEnterpriseSystem)
    {
        return tEnterpriseSystemMapper.selectTEnterpriseSystemList(tEnterpriseSystem);
    }

    /**
     * 新增企业制度管理
     * 
     * @param tEnterpriseSystem 企业制度管理
     * @return 结果
     */
    @Override
    public int insertTEnterpriseSystem(TEnterpriseSystem tEnterpriseSystem)
    {
        tEnterpriseSystem.setCreateTime(DateUtils.getNowDate());
        return tEnterpriseSystemMapper.insertTEnterpriseSystem(tEnterpriseSystem);
    }

    /**
     * 修改企业制度管理
     * 
     * @param tEnterpriseSystem 企业制度管理
     * @return 结果
     */
    @Override
    public int updateTEnterpriseSystem(TEnterpriseSystem tEnterpriseSystem)
    {
        tEnterpriseSystem.setUpdateTime(DateUtils.getNowDate());
        return tEnterpriseSystemMapper.updateTEnterpriseSystem(tEnterpriseSystem);
    }

    /**
     * 批量删除企业制度管理
     * 
     * @param systemIds 需要删除的企业制度管理ID
     * @return 结果
     */
    @Override
    public int deleteTEnterpriseSystemByIds(Long[] systemIds)
    {
        return tEnterpriseSystemMapper.deleteTEnterpriseSystemByIds(systemIds);
    }

    /**
     * 删除企业制度管理信息
     * 
     * @param systemId 企业制度管理ID
     * @return 结果
     */
    @Override
    public int deleteTEnterpriseSystemById(Long systemId)
    {
        return tEnterpriseSystemMapper.deleteTEnterpriseSystemById(systemId);
    }
}
