package com.zehong.system.service.impl;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEmergencyCrewMapper;
import com.zehong.system.domain.TEmergencyCrew;
import com.zehong.system.service.ITEmergencyCrewService;

/**
 * 应急通讯人员管理Service业务层处理
 *
 * @author zehong
 * @date 2022-06-29
 */
@Service
public class TEmergencyCrewServiceImpl implements ITEmergencyCrewService
{
    @Autowired
    private TEmergencyCrewMapper tEmergencyCrewMapper;

    /**
     * 查询应急通讯人员管理
     *
     * @param communicationId 应急通讯人员管理ID
     * @return 应急通讯人员管理
     */
    @Override
    public TEmergencyCrew selectTEmergencyCrewById(Long communicationId)
    {
        return tEmergencyCrewMapper.selectTEmergencyCrewById(communicationId);
    }

    /**
     * 查询应急通讯人员管理列表
     *
     * @param tEmergencyCrew 应急通讯人员管理
     * @return 应急通讯人员管理
     */
    @Override
    public List<TEmergencyCrew> selectTEmergencyCrewList(TEmergencyCrew tEmergencyCrew)
    {
        return tEmergencyCrewMapper.selectTEmergencyCrewList(tEmergencyCrew);
    }

    /**
     * 新增应急通讯人员管理
     *
     * @param tEmergencyCrew 应急通讯人员管理
     * @return 结果
     */
    @Override
    public int insertTEmergencyCrew(TEmergencyCrew tEmergencyCrew)
    {
        tEmergencyCrew.setCreateTime(DateUtils.getNowDate());
        return tEmergencyCrewMapper.insertTEmergencyCrew(tEmergencyCrew);
    }

    /**
     * 修改应急通讯人员管理
     *
     * @param tEmergencyCrew 应急通讯人员管理
     * @return 结果
     */
    @Override
    public int updateTEmergencyCrew(TEmergencyCrew tEmergencyCrew)
    {
        tEmergencyCrew.setUpdateTime(DateUtils.getNowDate());
        return tEmergencyCrewMapper.updateTEmergencyCrew(tEmergencyCrew);
    }

    /**
     * 批量删除应急通讯人员管理
     *
     * @param communicationIds 需要删除的应急通讯人员管理ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyCrewByIds(Long[] communicationIds)
    {
        return tEmergencyCrewMapper.deleteTEmergencyCrewByIds(communicationIds);
    }

    /**
     * 删除应急通讯人员管理信息
     *
     * @param communicationId 应急通讯人员管理ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyCrewById(Long communicationId)
    {
        return tEmergencyCrewMapper.deleteTEmergencyCrewById(communicationId);
    }
}
