package com.zehong.system.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.*;
import com.zehong.system.mapper.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.service.ITContractorTrainResultService;

/**
 * 承包商及访客培训考试结果详情Service业务层处理
 *
 * @author zehong
 * @date 2022-12-27
 */
@Service
public class TContractorTrainResultServiceImpl implements ITContractorTrainResultService
{
    @Autowired
    private TContractorTrainResultMapper tContractorTrainResultMapper;
    @Autowired
    private TBankSubjectMapper tBankSubjectMapper;
    @Autowired
    private TContractorTrainCourseTopicMapper tContractorTrainCourseTopicMapper;
    @Autowired
    private TContractorTrainCourseMapper tContractorTrainCourseMapper;
    @Autowired
    private TContractorTrainResultDetailMapper tContractorTrainResultDetailMapper;

    /**
     * 查询承包商及访客培训考试结果详情
     *
     * @param resultId 承包商及访客培训考试结果详情ID
     * @return 承包商及访客培训考试结果详情
     */
    @Override
    public TContractorTrainResult selectTContractorTrainResultById(Long resultId)
    {
        return tContractorTrainResultMapper.selectTContractorTrainResultById(resultId);
    }

    /**
     * 查询承包商及访客培训考试结果详情列表
     *
     * @param tContractorTrainResult 承包商及访客培训考试结果详情
     * @return 承包商及访客培训考试结果详情
     */
    @Override
    public List<TContractorTrainResult> selectTContractorTrainResultList(TContractorTrainResult tContractorTrainResult)
    {
        return tContractorTrainResultMapper.selectTContractorTrainResultList(tContractorTrainResult);
    }

    /**
     * 新增承包商及访客培训考试结果详情
     *
     * @param tContractorTrainResult 承包商及访客培训考试结果详情
     * @return 结果
     */
    @Override
    public int insertTContractorTrainResult(TContractorTrainResult tContractorTrainResult)
    {
        tContractorTrainResult.setCreateTime(DateUtils.getNowDate());
        return tContractorTrainResultMapper.insertTContractorTrainResult(tContractorTrainResult);
    }

    /**
     * 修改承包商及访客培训考试结果详情
     *
     * @param tContractorTrainResult 承包商及访客培训考试结果详情
     * @return 结果
     */
    @Override
    public int updateTContractorTrainResult(TContractorTrainResult tContractorTrainResult)
    {
        return tContractorTrainResultMapper.updateTContractorTrainResult(tContractorTrainResult);
    }

    /**
     * 批量删除承包商及访客培训考试结果详情
     *
     * @param resultIds 需要删除的承包商及访客培训考试结果详情ID
     * @return 结果
     */
    @Override
    public int deleteTContractorTrainResultByIds(Long[] resultIds)
    {
        return tContractorTrainResultMapper.deleteTContractorTrainResultByIds(resultIds);
    }

    /**
     * 删除承包商及访客培训考试结果详情信息
     *
     * @param resultId 承包商及访客培训考试结果详情ID
     * @return 结果
     */
    @Override
    public int deleteTContractorTrainResultById(Long resultId)
    {
        return tContractorTrainResultMapper.deleteTContractorTrainResultById(resultId);
    }

    /**
     * 用户课程考试交卷
     * @param tContractorTrainResult
     */
    @Override
    public Map<String,Object> examination(TContractorTrainResult tContractorTrainResult) {
        TContractorTrainCourseTopic tContractorTrainCourseTopic=new TContractorTrainCourseTopic();
        String answers = tContractorTrainResult.getAnswers();
        //交卷答题
        String[] split = answers.split(",");
        //查询考试题和答案
        List<TContractorTrainCourseTopic> tContractorTrainCourseTopics = tContractorTrainCourseTopicMapper.selectTContractorTrainCourseTopicList(tContractorTrainCourseTopic);
        //正确答案数量
        int num = 0;
        for(Integer i=0;i<split.length;i++){
            if(Integer.parseInt(split[i])==tContractorTrainCourseTopics.get(i).getAnswer()){
                num++;
            }
        }
        TContractorTrainCourse tContractorTrainCourse=new TContractorTrainCourse();
        //查询需要正确几道题算通过
        TContractorTrainCourse itContractorTrainCourse = tContractorTrainCourseMapper.getITContractorTrainCourse(tContractorTrainCourse);
        //判断答题是否合格
        if(num>=itContractorTrainCourse.getQualifiedNum()){
            tContractorTrainResult.setIsQualified("0");
        }else {
            tContractorTrainResult.setIsQualified("1");
        }
        //答对数量
        tContractorTrainResult.setScore(String.valueOf(num));
        tContractorTrainResult.setCreateTime(new Date());
        //承包商及访客培训考试结果 添加方法
        tContractorTrainResultMapper.insertTContractorTrainResult(tContractorTrainResult);
        /**添加承包商及访客培训考试结果详情*/
        for (int n=0;n<split.length;n++){
            TContractorTrainResultDetail tContractorTrainResultDetail=new TContractorTrainResultDetail();
            //设置结果管理id
            tContractorTrainResultDetail.setResult(String.valueOf(tContractorTrainResult.getResultId()));
            //设置题目内容
            tContractorTrainResultDetail.setTopicTitle(tContractorTrainCourseTopics.get(n).getTopicTitle());
            //设置题目选项
            tContractorTrainResultDetail.setTopicOption(tContractorTrainCourseTopics.get(n).getTopicOption());
            //答案
            tContractorTrainResultDetail.setAnswer(tContractorTrainCourseTopics.get(n).getAnswer());
            //所选答案
            tContractorTrainResultDetail.setAnswerChoice(Integer.valueOf(split[n]));
            //答案结果
            if (Integer.valueOf(split[n])==tContractorTrainCourseTopics.get(n).getAnswer()){
                tContractorTrainResultDetail.setResult("0");
            }else {
                tContractorTrainResultDetail.setResult("1");
            }
            tContractorTrainResultDetail.setCreateTime(new Date());
            tContractorTrainResultDetail.setResultId(tContractorTrainResult.getResultId());
            tContractorTrainResultDetailMapper.insertTContractorTrainResultDetail(tContractorTrainResultDetail);
        }
        Map<String,Object> map = new HashMap<>();
        map.put("answer",num);
        map.put("qualifiedNum",itContractorTrainCourse.getQualifiedNum());
        map.put("topicNum",tContractorTrainCourseTopics.size());
        return map;
    }
}
