package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TContractorTrainResultDetailMapper;
import com.zehong.system.domain.TContractorTrainResultDetail;
import com.zehong.system.service.ITContractorTrainResultDetailService;

/**
 * 承包商及访客培训考试结果详情Service业务层处理
 * 
 * @author wu
 * @date 2022-12-30
 */
@Service
public class TContractorTrainResultDetailServiceImpl implements ITContractorTrainResultDetailService 
{
    @Autowired
    private TContractorTrainResultDetailMapper tContractorTrainResultDetailMapper;

    /**
     * 查询承包商及访客培训考试结果详情
     * 
     * @param detailId 承包商及访客培训考试结果详情ID
     * @return 承包商及访客培训考试结果详情
     */
    @Override
    public TContractorTrainResultDetail selectTContractorTrainResultDetailById(Long detailId)
    {
        return tContractorTrainResultDetailMapper.selectTContractorTrainResultDetailById(detailId);
    }

    /**
     * 查询承包商及访客培训考试结果详情列表
     * 
     * @param tContractorTrainResultDetail 承包商及访客培训考试结果详情
     * @return 承包商及访客培训考试结果详情
     */
    @Override
    public List<TContractorTrainResultDetail> selectTContractorTrainResultDetailList(TContractorTrainResultDetail tContractorTrainResultDetail)
    {
        return tContractorTrainResultDetailMapper.selectTContractorTrainResultDetailList(tContractorTrainResultDetail);
    }

    /**
     * 新增承包商及访客培训考试结果详情
     * 
     * @param tContractorTrainResultDetail 承包商及访客培训考试结果详情
     * @return 结果
     */
    @Override
    public int insertTContractorTrainResultDetail(TContractorTrainResultDetail tContractorTrainResultDetail)
    {
        tContractorTrainResultDetail.setCreateTime(DateUtils.getNowDate());
        return tContractorTrainResultDetailMapper.insertTContractorTrainResultDetail(tContractorTrainResultDetail);
    }

    /**
     * 修改承包商及访客培训考试结果详情
     * 
     * @param tContractorTrainResultDetail 承包商及访客培训考试结果详情
     * @return 结果
     */
    @Override
    public int updateTContractorTrainResultDetail(TContractorTrainResultDetail tContractorTrainResultDetail)
    {
        return tContractorTrainResultDetailMapper.updateTContractorTrainResultDetail(tContractorTrainResultDetail);
    }

    /**
     * 批量删除承包商及访客培训考试结果详情
     * 
     * @param detailIds 需要删除的承包商及访客培训考试结果详情ID
     * @return 结果
     */
    @Override
    public int deleteTContractorTrainResultDetailByIds(Long[] detailIds)
    {
        return tContractorTrainResultDetailMapper.deleteTContractorTrainResultDetailByIds(detailIds);
    }

    /**
     * 删除承包商及访客培训考试结果详情信息
     * 
     * @param detailId 承包商及访客培训考试结果详情ID
     * @return 结果
     */
    @Override
    public int deleteTContractorTrainResultDetailById(Long detailId)
    {
        return tContractorTrainResultDetailMapper.deleteTContractorTrainResultDetailById(detailId);
    }
}
