package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TContractorTrainCourse;
import com.zehong.system.domain.TContractorTrainCourseTopic;
import com.zehong.system.mapper.TContractorTrainCourseMapper;
import com.zehong.system.mapper.TContractorTrainCourseTopicMapper;
import com.zehong.system.service.ITContractorTrainCourseTopicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 承包商及访客培训题库Service业务层处理
 * 
 * @author zehong
 * @date 2022-12-27
 */
@Service
public class TContractorTrainCourseTopicServiceImpl implements ITContractorTrainCourseTopicService 
{
    @Autowired
    private TContractorTrainCourseTopicMapper tContractorTrainCourseTopicMapper;
    @Resource
    private TContractorTrainCourseMapper tContractorTrainCourseMapper;

    /**
     * 查询承包商及访客培训题库
     * 
     * @param topicId 承包商及访客培训题库ID
     * @return 承包商及访客培训题库
     */
    @Override
    public TContractorTrainCourseTopic selectTContractorTrainCourseTopicById(Long topicId)
    {
        return tContractorTrainCourseTopicMapper.selectTContractorTrainCourseTopicById(topicId);
    }

    /**
     * 查询承包商及访客培训题库列表
     * 
     * @param tContractorTrainCourseTopic 承包商及访客培训题库
     * @return 承包商及访客培训题库
     */
    @Override
    public List<TContractorTrainCourseTopic> selectTContractorTrainCourseTopicList(TContractorTrainCourseTopic tContractorTrainCourseTopic)
    {
        return tContractorTrainCourseTopicMapper.selectTContractorTrainCourseTopicList(tContractorTrainCourseTopic);
    }

    /**
     * 新增承包商及访客培训题库
     * 
     * @param tContractorTrainCourseTopic 承包商及访客培训题库
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertTContractorTrainCourseTopic(TContractorTrainCourseTopic tContractorTrainCourseTopic)
    {
        TContractorTrainCourse course = tContractorTrainCourseMapper.selectTContractorTrainCourseById(tContractorTrainCourseTopic.getContractorCourseId());
        if(course!=null){
            course.setTopicNum(course.getTopicNum()+1);
            tContractorTrainCourseMapper.updateTContractorTrainCourse(course);
        }
        tContractorTrainCourseTopic.setCreateTime(DateUtils.getNowDate());
        return tContractorTrainCourseTopicMapper.insertTContractorTrainCourseTopic(tContractorTrainCourseTopic);
    }

    /**
     * 修改承包商及访客培训题库
     * 
     * @param tContractorTrainCourseTopic 承包商及访客培训题库
     * @return 结果
     */
    @Override
    public int updateTContractorTrainCourseTopic(TContractorTrainCourseTopic tContractorTrainCourseTopic)
    {
        return tContractorTrainCourseTopicMapper.updateTContractorTrainCourseTopic(tContractorTrainCourseTopic);
    }

    /**
     * 批量删除承包商及访客培训题库
     * 
     * @param topicIds 需要删除的承包商及访客培训题库ID
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int deleteTContractorTrainCourseTopicByIds(Long[] topicIds)
    {
        for(Long topicId : topicIds){
            TContractorTrainCourseTopic topic = tContractorTrainCourseTopicMapper.selectTContractorTrainCourseTopicById(topicId);
            TContractorTrainCourse course = tContractorTrainCourseMapper.selectTContractorTrainCourseById(topic.getContractorCourseId());
            if(course!=null){
                course.setTopicNum(course.getTopicNum() - 1);
                tContractorTrainCourseMapper.updateTContractorTrainCourse(course);
            }
        }

        return tContractorTrainCourseTopicMapper.deleteTContractorTrainCourseTopicByIds(topicIds);
    }

    /**
     * 删除承包商及访客培训题库信息
     * 
     * @param topicId 承包商及访客培训题库ID
     * @return 结果
     */
    @Override
    public int deleteTContractorTrainCourseTopicById(Long topicId)
    {
        return tContractorTrainCourseTopicMapper.deleteTContractorTrainCourseTopicById(topicId);
    }
}
