package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TContractorTrainCourseMapper;
import com.zehong.system.domain.TContractorTrainCourse;
import com.zehong.system.service.ITContractorTrainCourseService;

/**
 * 承包商及访客培训Service业务层处理
 *
 * @author zehong
 * @date 2022-12-27
 */
@Service
public class TContractorTrainCourseServiceImpl implements ITContractorTrainCourseService
{
    @Autowired
    private TContractorTrainCourseMapper tContractorTrainCourseMapper;

    /**
     * 查询承包商及访客培训
     *
     * @param contractorCourseId 承包商及访客培训ID
     * @return 承包商及访客培训
     */
    @Override
    public TContractorTrainCourse selectTContractorTrainCourseById(Long contractorCourseId)
    {
        return tContractorTrainCourseMapper.selectTContractorTrainCourseById(contractorCourseId);
    }

    /**
     * 查询承包商及访客培训列表
     *
     * @param tContractorTrainCourse 承包商及访客培训
     * @return 承包商及访客培训
     */
    @Override
    public List<TContractorTrainCourse> selectTContractorTrainCourseList(TContractorTrainCourse tContractorTrainCourse)
    {
        return tContractorTrainCourseMapper.selectTContractorTrainCourseList(tContractorTrainCourse);
    }

    /**
     * 新增承包商及访客培训
     *
     * @param tContractorTrainCourse 承包商及访客培训
     * @return 结果
     */
    @Override
    public int insertTContractorTrainCourse(TContractorTrainCourse tContractorTrainCourse)
    {
        tContractorTrainCourse.setCreateTime(DateUtils.getNowDate());
        return tContractorTrainCourseMapper.insertTContractorTrainCourse(tContractorTrainCourse);
    }

    /**
     * 修改承包商及访客培训
     *
     * @param tContractorTrainCourse 承包商及访客培训
     * @return 结果
     */
    @Override
    public int updateTContractorTrainCourse(TContractorTrainCourse tContractorTrainCourse)
    {
        return tContractorTrainCourseMapper.updateTContractorTrainCourse(tContractorTrainCourse);
    }

    /**
     * 批量删除承包商及访客培训
     *
     * @param contractorCourseIds 需要删除的承包商及访客培训ID
     * @return 结果
     */
    @Override
    public int deleteTContractorTrainCourseByIds(Long[] contractorCourseIds)
    {
        return tContractorTrainCourseMapper.deleteTContractorTrainCourseByIds(contractorCourseIds);
    }

    /**
     * 删除承包商及访客培训信息
     *
     * @param contractorCourseId 承包商及访客培训ID
     * @return 结果
     */
    @Override
    public int deleteTContractorTrainCourseById(Long contractorCourseId)
    {
        return tContractorTrainCourseMapper.deleteTContractorTrainCourseById(contractorCourseId);
    }

    /**
     * 查询承包商及访客培训
     * @param tContractorTrainCourse
     * @return
     */
    @Override
    public TContractorTrainCourse getITContractorTrainCourse(TContractorTrainCourse tContractorTrainCourse) {
        return tContractorTrainCourseMapper.getITContractorTrainCourse(tContractorTrainCourse);
    }
}
