package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.vo.TContractorPersonVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TContractorPersonMapper;
import com.zehong.system.domain.TContractorPerson;
import com.zehong.system.service.ITContractorPersonService;

/**
 * 承包商人员信息Service业务层处理
 * 
 * @author zehong
 * @date 2022-06-29
 */
@Service
public class TContractorPersonServiceImpl implements ITContractorPersonService 
{
    @Autowired
    private TContractorPersonMapper tContractorPersonMapper;

    /**
     * 查询承包商人员信息
     * 
     * @param id 承包商人员信息ID
     * @return 承包商人员信息
     */
    @Override
    public TContractorPersonVo selectTContractorPersonById(Long id)
    {
        return tContractorPersonMapper.selectTContractorPersonById(id);
    }

    /**
     * 查询承包商人员信息列表
     * 
     * @param tContractorPerson 承包商人员信息
     * @return 承包商人员信息
     */
    @Override
    public List<TContractorPersonVo> selectTContractorPersonList(TContractorPerson tContractorPerson)
    {
        return tContractorPersonMapper.selectTContractorPersonList(tContractorPerson);
    }

    /**
     * 新增承包商人员信息
     * 
     * @param tContractorPerson 承包商人员信息
     * @return 结果
     */
    @Override
    public int insertTContractorPerson(TContractorPerson tContractorPerson)
    {
        tContractorPerson.setCreateTime(DateUtils.getNowDate());
        return tContractorPersonMapper.insertTContractorPerson(tContractorPerson);
    }

    /**
     * 修改承包商人员信息
     * 
     * @param tContractorPerson 承包商人员信息
     * @return 结果
     */
    @Override
    public int updateTContractorPerson(TContractorPerson tContractorPerson)
    {
        tContractorPerson.setUpdateTime(DateUtils.getNowDate());
        return tContractorPersonMapper.updateTContractorPerson(tContractorPerson);
    }

    /**
     * 批量删除承包商人员信息
     * 
     * @param ids 需要删除的承包商人员信息ID
     * @return 结果
     */
    @Override
    public int deleteTContractorPersonByIds(Long[] ids)
    {
        return tContractorPersonMapper.deleteTContractorPersonByIds(ids);
    }

    /**
     * 删除承包商人员信息信息
     * 
     * @param id 承包商人员信息ID
     * @return 结果
     */
    @Override
    public int deleteTContractorPersonById(Long id)
    {
        return tContractorPersonMapper.deleteTContractorPersonById(id);
    }
}
