package com.zehong.system.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import com.alibaba.excel.EasyExcel;
import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TDeviceInfo;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TBankSubjectMapper;
import com.zehong.system.domain.TBankSubject;
import com.zehong.system.service.ITBankSubjectService;
import org.springframework.web.multipart.MultipartFile;

/**
 * 题库题目Service业务层处理
 *
 * @author zehong
 * @date 2022-12-15
 */
@Service
public class TBankSubjectServiceImpl implements ITBankSubjectService
{
    @Autowired
    private TBankSubjectMapper tBankSubjectMapper;

    /**
     * 查询题库题目
     *
     * @param subjectId 题库题目ID
     * @return 题库题目
     */
    @Override
    public TBankSubject selectTBankSubjectById(Long subjectId)
    {
        return tBankSubjectMapper.selectTBankSubjectById(subjectId);
    }

    /**
     * 查询题库题目列表
     *
     * @param tBankSubject 题库题目
     * @return 题库题目
     */
    @Override
    public List<TBankSubject> selectTBankSubjectList(TBankSubject tBankSubject)
    {
        return tBankSubjectMapper.selectTBankSubjectList(tBankSubject);
    }

    /**
     * 新增题库题目
     *
     * @param tBankSubject 题库题目
     * @return 结果
     */
    @Override
    public int insertTBankSubject(TBankSubject tBankSubject)
    {
        return tBankSubjectMapper.insertTBankSubject(tBankSubject);
    }

    /**
     * 修改题库题目
     *
     * @param tBankSubject 题库题目
     * @return 结果
     */
    @Override
    public int updateTBankSubject(TBankSubject tBankSubject)
    {
        return tBankSubjectMapper.updateTBankSubject(tBankSubject);
    }

    /**
     * 批量删除题库题目
     *
     * @param subjectIds 需要删除的题库题目ID
     * @return 结果
     */
    @Override
    public int deleteTBankSubjectByIds(Long[] subjectIds)
    {
        return tBankSubjectMapper.deleteTBankSubjectByIds(subjectIds);
    }

    /**
     * 删除题库题目信息
     *
     * @param subjectId 题库题目ID
     * @return 结果
     */
    @Override
    public int deleteTBankSubjectById(Long subjectId)
    {
        return tBankSubjectMapper.deleteTBankSubjectById(subjectId);
    }

    /**
     * 题目信息导入
     * @param
     * @param updateSupport
     * @return
     */
    @Override
    public String importDevice(MultipartFile file, boolean updateSupport) throws IOException {


        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        //文件输入流
//        InputStream in=file.getInputStream();
        //调用方法进行读取
        //吧service直接注入进来为了后面能使用

        //因为在listener中不能注入service所以在这个serviceiimpl中，通过listener使service注入进去，为了在listener中能够使用service中的发方法save/

//        for (TBankSubject device : userList)
//        {
//            try
//            {
//              System.out.println(device);
//            }
//            catch (Exception e)
//            {
//                failureNum++;
//                String msg = "<br/>" + failureNum + "、设备 " + device.getTopicOption() + "题目" + " 导入失败：";
//                failureMsg.append(msg + e.getMessage());
//
//            }
//        }
        if (failureNum > 0)
        {
            failureMsg.insert(0, "导入完成，共 " + failureNum + " 条数据格式不正确，错误如下：");
            throw new CustomException(failureMsg.toString());
        }
        else
        {
            successMsg.insert(0, "数据已全部导入成功！共 " + successNum + " 条");
        }
        return successMsg.toString();
    }

    /**
     * Excel导入
     * @param list
     */
    @Override
    public void insertBank(List<TBankSubject> list) {
        tBankSubjectMapper.insertBank(list);
    }
}
