package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TWorkPermit;

/**
 * 作业许可证Service接口
 * 
 * @author zehong
 * @date 2022-08-18
 */
public interface ITWorkPermitService 
{
    /**
     * 查询作业许可证
     * 
     * @param workPermitId 作业许可证ID
     * @return 作业许可证
     */
    public TWorkPermit selectTWorkPermitById(Long workPermitId);

    /**
     * 查询作业许可证列表
     * 
     * @param tWorkPermit 作业许可证
     * @return 作业许可证集合
     */
    public List<TWorkPermit> selectTWorkPermitList(TWorkPermit tWorkPermit);

    /**
     * 新增作业许可证
     * 
     * @param tWorkPermit 作业许可证
     * @return 结果
     */
    public int insertTWorkPermit(TWorkPermit tWorkPermit);

    int judgeSignUpdateTWorkPermit(TWorkPermit tWorkPermit);

    /**
     * 修改作业许可证
     * 
     * @param tWorkPermit 作业许可证
     * @return 结果
     */
    public int updateTWorkPermit(TWorkPermit tWorkPermit);

    /**
     * 批量删除作业许可证
     * 
     * @param workPermitIds 需要删除的作业许可证ID
     * @return 结果
     */
    public int deleteTWorkPermitByIds(Long[] workPermitIds);

    /**
     * 删除作业许可证信息
     * 
     * @param workPermitId 作业许可证ID
     * @return 结果
     */
    public int deleteTWorkPermitById(Long workPermitId);

    /**
     * 根据登录用户查询作业单
     * @param tWorkPermit
     * @return
     */
    List<TWorkPermit> selectTWorkPermitListByLoginUser(TWorkPermit tWorkPermit);

    /**
     *
     * @param workPermitId
     * @return
     */
    int selectUpdate(Long workPermitId);
}
