package com.zehong.system.service;

import com.zehong.system.domain.TTrainCourseTopic;
import com.zehong.system.domain.vo.BatchTopicVo;

import java.util.List;

/**
 * 培训课程题库Service接口
 * 
 * @author zehong
 * @date 2022-09-19
 */
public interface ITTrainCourseTopicService 
{
    /**
     * 查询培训课程题库
     * 
     * @param topicId 培训课程题库ID
     * @return 培训课程题库
     */
    public TTrainCourseTopic selectTTrainCourseTopicById(Long topicId);

    /**
     * 查询培训课程题库列表
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 培训课程题库集合
     */
    public List<TTrainCourseTopic> selectTTrainCourseTopicList(TTrainCourseTopic tTrainCourseTopic);
    public List<TTrainCourseTopic> selectCourseTopicList(Long courseId);

    /**
     * 新增培训课程题库
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 结果
     */
    public int insertTTrainCourseTopic(TTrainCourseTopic tTrainCourseTopic);

    /**
     * 修改培训课程题库
     * 
     * @param tTrainCourseTopic 培训课程题库
     * @return 结果
     */
    public int updateTTrainCourseTopic(TTrainCourseTopic tTrainCourseTopic);

    /**
     * 批量删除培训课程题库
     * 
     * @param topicIds 需要删除的培训课程题库ID
     * @return 结果
     */
    public int deleteTTrainCourseTopicByIds(Long[] topicIds);

    /**
     * 删除培训课程题库信息
     * 
     * @param topicId 培训课程题库ID
     * @return 结果
     */
    public int deleteTTrainCourseTopicById(Long topicId);

    /**
     * 题库批量导入试题
     * @param batchTopicVo 试题实体
     * @return int
     */
    int bachAddTopic(BatchTopicVo batchTopicVo);
}
