package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.StatisticsTrainCourse;
import com.zehong.system.domain.TTrainCourse;
import com.zehong.system.domain.TTrainUserCourse;
import com.zehong.system.domain.vo.UserCourseVo;

/**
 * 培训课程Service接口
 * 
 * @author zehong
 * @date 2022-09-19
 */
public interface ITTrainCourseService 
{
    /**
     * 查询培训课程
     * 
     * @param courseId 培训课程ID
     * @return 培训课程
     */
    public TTrainCourse selectTTrainCourseById(Long courseId);

    /**
     * 发布培训课程
     * @param courseId
     * @return
     */
    public Integer selectTTrainCourseRelease(Long courseId);

    /**
     * 查询培训课程列表
     * 
     * @param tTrainCourse 培训课程
     * @return 培训课程集合
     */
    public List<TTrainCourse> selectTTrainCourseList(TTrainCourse tTrainCourse);

    /**
     * 新增培训课程
     * 
     * @param tTrainCourse 培训课程
     * @return 结果
     */
    public Long insertTTrainCourse(TTrainCourse tTrainCourse);

    /**
     * 修改培训课程
     * 
     * @param tTrainCourse 培训课程
     * @return 结果
     */
    public int updateTTrainCourse(TTrainCourse tTrainCourse);

    /**
     * 批量删除培训课程
     * 
     * @param courseIds 需要删除的培训课程ID
     * @return 结果
     */
    public int deleteTTrainCourseByIds(Long[] courseIds);

    /**
     * 删除培训课程信息
     * 
     * @param courseId 培训课程ID
     * @return 结果
     */
    public int deleteTTrainCourseById(Long courseId);

    /**
     * 用户id
     * @param userId
     * @return
     */
    public List<UserCourseVo> userCourseList(Long userId,Integer type);
    public List<UserCourseVo> youkeCourseList(Long userId,Integer type);
    /**
     * 考试
     */
    public Map<String,Object>  examination(Long userCourseId,String[] answers);

    /**
     * 考试发布
     * @param tTrainCourse 考试实体
     * @return int
     */
    int testPublish( TTrainCourse tTrainCourse);

    /**
     * 考试统计接口
     * @param statisticsTrainCourse 统计实体
     * @return List<StatisticsTrainCourse>
     */
    List<StatisticsTrainCourse> statisticsTrainCourse(StatisticsTrainCourse statisticsTrainCourse);

    /**
     * 根据考试查询人员考试详情
     * @param courseId 考试id
     * @return List<TTrainUserCourse>
     */
    List<TTrainUserCourse> testPersonDetailByCourseId(Long courseId);
}

