package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TTrainCourseBank;

/**
 * bankService接口
 * 
 * @author zehong
 * @date 2022-12-14
 */
public interface ITTrainCourseBankService 
{
    /**
     * 查询bank
     * 
     * @param bankId bankID
     * @return bank
     */
    public TTrainCourseBank selectTTrainCourseBankById(Long bankId);

    /**
     * 查询bank列表
     * 
     * @param tTrainCourseBank bank
     * @return bank集合
     */
    public List<TTrainCourseBank> selectTTrainCourseBankList(TTrainCourseBank tTrainCourseBank);

    /**
     * 新增bank
     * 
     * @param tTrainCourseBank bank
     * @return 结果
     */
    public int insertTTrainCourseBank(TTrainCourseBank tTrainCourseBank);

    /**
     * 修改bank
     * 
     * @param tTrainCourseBank bank
     * @return 结果
     */
    public int updateTTrainCourseBank(TTrainCourseBank tTrainCourseBank);

    /**
     * 批量删除bank
     * 
     * @param bankIds 需要删除的bankID
     * @return 结果
     */
    public int deleteTTrainCourseBankByIds(Long[] bankIds);

    /**
     * 删除bank信息
     * 
     * @param bankId bankID
     * @return 结果
     */
    public int deleteTTrainCourseBankById(Long bankId);
}
