package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSpecialWorkPermit;
import com.zehong.system.domain.vo.TWorkPermitVo;

/**
 * 特殊作业许可证Service接口
 * 
 * @author zehong
 * @date 2022-08-25
 */
public interface ITSpecialWorkPermitService 
{
    /**
     * 查询特殊作业许可证
     * 
     * @param specialWorkPermitId 特殊作业许可证ID
     * @return 特殊作业许可证
     */
    public TSpecialWorkPermit selectTSpecialWorkPermitById(Long specialWorkPermitId);

    /**
     * 查询特殊作业许可证列表
     * 
     * @param tSpecialWorkPermit 特殊作业许可证
     * @return 特殊作业许可证集合
     */
    public List<TSpecialWorkPermit> selectTSpecialWorkPermitList(TSpecialWorkPermit tSpecialWorkPermit);

    /**
     * 新增特殊作业许可证
     * 
     * @param tSpecialWorkPermit 特殊作业许可证
     * @return 结果
     */
    public int insertTSpecialWorkPermit(TSpecialWorkPermit tSpecialWorkPermit);

    /**
     * 修改特殊作业许可证
     * 
     * @param tSpecialWorkPermit 特殊作业许可证
     * @return 结果
     */
    public int updateTSpecialWorkPermit(TSpecialWorkPermit tSpecialWorkPermit);

    /**
     * 批量删除特殊作业许可证
     * 
     * @param specialWorkPermitIds 需要删除的特殊作业许可证ID
     * @return 结果
     */
    public int deleteTSpecialWorkPermitByIds(Long[] specialWorkPermitIds);

    /**
     * 删除特殊作业许可证信息
     * 
     * @param specialWorkPermitId 特殊作业许可证ID
     * @return 结果
     */
    public int deleteTSpecialWorkPermitById(Long specialWorkPermitId);

    /**
     * 批量新增特殊许可单
     * @param tWorkPermitVo 许可单实体
     * @return
     */
   int addSpecialPermit(TWorkPermitVo tWorkPermitVo);

    /**
     * 根据许可证id查询许可单
     * @param workPermitId 许可证id
     * @return
     */
   TWorkPermitVo getSpecialWorkPermitByWorkPermitId(Long workPermitId);

    /**
     * 更新作业单状态
     * @param tSpecialWorkPermit 特殊作业单
     * @return
     */
   int updateSpecialWorkStatus (TSpecialWorkPermit tSpecialWorkPermit);
}
