package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSpecialDeviceRecord;
import com.zehong.system.domain.vo.TSpecialDeviceRecordVo;

/**
 * 特种设备台账Service接口
 * 
 * @author zehong
 * @date 2022-07-02
 */
public interface ITSpecialDeviceRecordService 
{
    /**
     * 查询特种设备台账
     * 
     * @param id 特种设备台账ID
     * @return 特种设备台账
     */
    public TSpecialDeviceRecordVo selectTSpecialDeviceRecordById(Long id);

    /**
     * 查询特种设备台账列表
     * 
     * @param tSpecialDeviceRecord 特种设备台账
     * @return 特种设备台账集合
     */
    public List<TSpecialDeviceRecordVo> selectTSpecialDeviceRecordList(TSpecialDeviceRecord tSpecialDeviceRecord);

    /**
     * 新增特种设备台账
     * 
     * @param tSpecialDeviceRecord 特种设备台账
     * @return 结果
     */
    public int insertTSpecialDeviceRecord(TSpecialDeviceRecord tSpecialDeviceRecord);

    /**
     * 修改特种设备台账
     * 
     * @param tSpecialDeviceRecord 特种设备台账
     * @return 结果
     */
    public int updateTSpecialDeviceRecord(TSpecialDeviceRecord tSpecialDeviceRecord);

    /**
     * 批量删除特种设备台账
     * 
     * @param ids 需要删除的特种设备台账ID
     * @return 结果
     */
    public int deleteTSpecialDeviceRecordByIds(Long[] ids);

    /**
     * 删除特种设备台账信息
     * 
     * @param id 特种设备台账ID
     * @return 结果
     */
    public int deleteTSpecialDeviceRecordById(Long id);
}
