package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSafetyCommitmentAnnouncement;

/**
 * 安全承诺公告Service接口
 * 
 * @author zehong
 * @date 2022-12-21
 */
public interface ITSafetyCommitmentAnnouncementService 
{
    /**
     * 查询安全承诺公告
     * 
     * @param id 安全承诺公告ID
     * @return 安全承诺公告
     */
    public TSafetyCommitmentAnnouncement selectTSafetyCommitmentAnnouncementById(Long id);

    /**
     * 查询安全承诺公告列表
     * 
     * @param tSafetyCommitmentAnnouncement 安全承诺公告
     * @return 安全承诺公告集合
     */
    public List<TSafetyCommitmentAnnouncement> selectTSafetyCommitmentAnnouncementList(TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement);

    /**
     * 新增安全承诺公告
     * 
     * @param tSafetyCommitmentAnnouncement 安全承诺公告
     * @return 结果
     */
    public int insertTSafetyCommitmentAnnouncement(TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement);

    /**
     * 修改安全承诺公告
     * 
     * @param tSafetyCommitmentAnnouncement 安全承诺公告
     * @return 结果
     */
    public int updateTSafetyCommitmentAnnouncement(TSafetyCommitmentAnnouncement tSafetyCommitmentAnnouncement);

    /**
     * 批量删除安全承诺公告
     * 
     * @param ids 需要删除的安全承诺公告ID
     * @return 结果
     */
    public int deleteTSafetyCommitmentAnnouncementByIds(Long[] ids);

    /**
     * 删除安全承诺公告信息
     * 
     * @param id 安全承诺公告ID
     * @return 结果
     */
    public int deleteTSafetyCommitmentAnnouncementById(Long id);
}
