package com.zehong.system.service;

import java.util.List;

import com.zehong.system.domain.TNfcRecord;
import com.zehong.system.domain.TNfcSetting;

/**
 * settingService接口
 *
 * @author zehong
 * @date 2022-10-17
 */
public interface ITNfcSettingService
{
    /**
     * 查询setting
     *
     * @param nfcId settingID
     * @return setting
     */
    public TNfcSetting selectTNfcSettingById(Long nfcId);

    /**
     * 根据nfc获取详情
     * @param nfcNum
     * @return
     */
    public TNfcSetting getInfoByNfcNum(String nfcNum);
    /**
     * 查询setting列表
     *
     * @param tNfcSetting setting
     * @return setting集合
     */
    public List<TNfcSetting> selectTNfcSettingList(TNfcSetting tNfcSetting);

    /**
     * 新增setting
     *
     * @param tNfcSetting setting
     * @return 结果
     */
    public int insertTNfcSetting(TNfcSetting tNfcSetting);

    /**
     * 修改setting
     *
     * @param tNfcSetting setting
     * @return 结果
     */
    public int updateTNfcSetting(TNfcSetting tNfcSetting);

    /**
     * 批量删除setting
     *
     * @param nfcIds 需要删除的settingID
     * @return 结果
     */
    public int deleteTNfcSettingByIds(Long[] nfcIds);

    /**
     * 删除setting信息
     *
     * @param nfcId settingID
     * @return 结果
     */
    public int deleteTNfcSettingById(Long nfcId);

    /**
     * 巡检打卡查询列表
     * @param tNfcSetting
     * @return
     */
    List<TNfcRecord> punchClockList(TNfcSetting tNfcSetting);

    /**
     * 巡检打卡详细信息
     * @param recordId
     * @return
     */
    TNfcRecord getPunchClockList(Long recordId);
}
