package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TMaterialInfo;

/**
 * 应急物资管理Service接口
 * 
 * @author zehong
 * @date 2022-07-01
 */
public interface ITMaterialInfoService 
{
    /**
     * 查询应急物资管理
     * 
     * @param id 应急物资管理ID
     * @return 应急物资管理
     */
    public TMaterialInfo selectTMaterialInfoById(Long id);

    /**
     * 查询应急物资管理列表
     * 
     * @param tMaterialInfo 应急物资管理
     * @return 应急物资管理集合
     */
    public List<TMaterialInfo> selectTMaterialInfoList(TMaterialInfo tMaterialInfo);

    /**
     * 新增应急物资管理
     * 
     * @param tMaterialInfo 应急物资管理
     * @return 结果
     */
    public int insertTMaterialInfo(TMaterialInfo tMaterialInfo);

    /**
     * 修改应急物资管理
     * 
     * @param tMaterialInfo 应急物资管理
     * @return 结果
     */
    public int updateTMaterialInfo(TMaterialInfo tMaterialInfo);

    /**
     * 批量删除应急物资管理
     * 
     * @param ids 需要删除的应急物资管理ID
     * @return 结果
     */
    public int deleteTMaterialInfoByIds(Long[] ids);

    /**
     * 删除应急物资管理信息
     * 
     * @param id 应急物资管理ID
     * @return 结果
     */
    public int deleteTMaterialInfoById(Long id);
}
