package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TInvestment;

/**
 * 投入台账Service接口
 * 
 * @author zehong
 * @date 2022-06-24
 */
public interface ITInvestmentService 
{
    /**
     * 查询投入台账
     * 
     * @param id 投入台账ID
     * @return 投入台账
     */
    public TInvestment selectTInvestmentById(Long id);

    /**
     * 查询投入台账列表
     * 
     * @param tInvestment 投入台账
     * @return 投入台账集合
     */
    public List<TInvestment> selectTInvestmentList(TInvestment tInvestment);

    /**
     * 新增投入台账
     * 
     * @param tInvestment 投入台账
     * @return 结果
     */
    public int insertTInvestment(TInvestment tInvestment);

    /**
     * 修改投入台账
     * 
     * @param tInvestment 投入台账
     * @return 结果
     */
    public int updateTInvestment(TInvestment tInvestment);

    /**
     * 批量删除投入台账
     * 
     * @param ids 需要删除的投入台账ID
     * @return 结果
     */
    public int deleteTInvestmentByIds(Long[] ids);

    /**
     * 删除投入台账信息
     * 
     * @param id 投入台账ID
     * @return 结果
     */
    public int deleteTInvestmentById(Long id);
}
