package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TInspectWorkPointRecorde;

/**
 * 巡检点记录信息Service接口
 * 
 * @author zehong
 * @date 2022-06-21
 */
public interface ITInspectWorkPointRecordeService 
{
    /**
     * 查询巡检点记录信息
     * 
     * @param pointId 巡检点记录信息ID
     * @return 巡检点记录信息
     */
    public TInspectWorkPointRecorde selectTInspectWorkPointRecordeById(Long pointId);

    /**
     * 查询巡检点记录信息列表
     * 
     * @param tInspectWorkPointRecorde 巡检点记录信息
     * @return 巡检点记录信息集合
     */
    public List<TInspectWorkPointRecorde> selectTInspectWorkPointRecordeList(TInspectWorkPointRecorde tInspectWorkPointRecorde);

    /**
     * 新增巡检点记录信息
     * 
     * @param tInspectWorkPointRecorde 巡检点记录信息
     * @return 结果
     */
    public int insertTInspectWorkPointRecorde(TInspectWorkPointRecorde tInspectWorkPointRecorde);

    /**
     * 修改巡检点记录信息
     * 
     * @param tInspectWorkPointRecorde 巡检点记录信息
     * @return 结果
     */
    public int updateTInspectWorkPointRecorde(TInspectWorkPointRecorde tInspectWorkPointRecorde);

    /**
     * 批量删除巡检点记录信息
     * 
     * @param pointIds 需要删除的巡检点记录信息ID
     * @return 结果
     */
    public int deleteTInspectWorkPointRecordeByIds(Long[] pointIds);

    /**
     * 删除巡检点记录信息信息
     * 
     * @param pointId 巡检点记录信息ID
     * @return 结果
     */
    public int deleteTInspectWorkPointRecordeById(Long pointId);
}
