package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.THiddenTroubleAssessment;

/**
 * 排查评估Service接口
 * 
 * @author zehong
 * @date 2022-07-12
 */
public interface ITHiddenTroubleAssessmentService 
{
    /**
     * 查询排查评估
     * 
     * @param assessmentId 排查评估ID
     * @return 排查评估
     */
    public THiddenTroubleAssessment selectTHiddenTroubleAssessmentById(Long assessmentId);
    public THiddenTroubleAssessment selectTHiddenTroubleAssessmentByWorkId(Long workId);

    /**
     * 查询排查评估列表
     * 
     * @param tHiddenTroubleAssessment 排查评估
     * @return 排查评估集合
     */
    public List<THiddenTroubleAssessment> selectTHiddenTroubleAssessmentList(THiddenTroubleAssessment tHiddenTroubleAssessment);

    /**
     * 新增排查评估
     * 
     * @param tHiddenTroubleAssessment 排查评估
     * @return 结果
     */
    public int insertTHiddenTroubleAssessment(THiddenTroubleAssessment tHiddenTroubleAssessment);

    /**
     * 修改排查评估
     * 
     * @param tHiddenTroubleAssessment 排查评估
     * @return 结果
     */
    public int updateTHiddenTroubleAssessment(THiddenTroubleAssessment tHiddenTroubleAssessment);

    /**
     * 批量删除排查评估
     * 
     * @param assessmentIds 需要删除的排查评估ID
     * @return 结果
     */
    public int deleteTHiddenTroubleAssessmentByIds(Long[] assessmentIds);

    /**
     * 删除排查评估信息
     * 
     * @param assessmentId 排查评估ID
     * @return 结果
     */
    public int deleteTHiddenTroubleAssessmentById(Long assessmentId);
}
