package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TEntranceGuardPersonInfo;

/**
 * 门禁人员信息Service接口
 * 
 * @author zehong
 * @date 2022-11-02
 */
public interface ITEntranceGuardPersonInfoService 
{
    /**
     * 查询门禁人员信息
     * 
     * @param entranceGuardPersonId 门禁人员信息ID
     * @return 门禁人员信息
     */
    public TEntranceGuardPersonInfo selectTEntranceGuardPersonInfoById(Long entranceGuardPersonId);

    /**
     * 查询门禁人员信息列表
     * 
     * @param tEntranceGuardPersonInfo 门禁人员信息
     * @return 门禁人员信息集合
     */
    public List<TEntranceGuardPersonInfo> selectTEntranceGuardPersonInfoList(TEntranceGuardPersonInfo tEntranceGuardPersonInfo);

    /**
     * 新增门禁人员信息
     * 
     * @param tEntranceGuardPersonInfo 门禁人员信息
     * @return 结果
     */
    public int insertTEntranceGuardPersonInfo(TEntranceGuardPersonInfo tEntranceGuardPersonInfo);

    /**
     * 修改门禁人员信息
     * 
     * @param tEntranceGuardPersonInfo 门禁人员信息
     * @return 结果
     */
    public int updateTEntranceGuardPersonInfo(TEntranceGuardPersonInfo tEntranceGuardPersonInfo);

    /**
     * 批量删除门禁人员信息
     * 
     * @param entranceGuardPersonIds 需要删除的门禁人员信息ID
     * @return 结果
     */
    public int deleteTEntranceGuardPersonInfoByIds(Long[] entranceGuardPersonIds);

    /**
     * 删除门禁人员信息信息
     * 
     * @param entranceGuardPersonId 门禁人员信息ID
     * @return 结果
     */
    public int deleteTEntranceGuardPersonInfoById(Long entranceGuardPersonId);

    /**
     * 二道门人员信息初始化
     */
    Map<String,Object> getEntranceGuardPersonInfo();
}
