package com.zehong.system.service;
import java.util.List;
import com.zehong.system.domain.TEmergencyCrew;

/**
 * 应急通讯人员管理Service接口
 *
 * @author zehong
 * @date 2022-06-29
 */
public interface ITEmergencyCrewService
{
    /**
     * 查询应急通讯人员管理
     *
     * @param communicationId 应急通讯人员管理ID
     * @return 应急通讯人员管理
     */
    public TEmergencyCrew selectTEmergencyCrewById(Long communicationId);

    /**
     * 查询应急通讯人员管理列表
     *
     * @param tEmergencyCrew 应急通讯人员管理
     * @return 应急通讯人员管理集合
     */
    public List<TEmergencyCrew> selectTEmergencyCrewList(TEmergencyCrew tEmergencyCrew);

    /**
     * 新增应急通讯人员管理
     *
     * @param tEmergencyCrew 应急通讯人员管理
     * @return 结果
     */
    public int insertTEmergencyCrew(TEmergencyCrew tEmergencyCrew);

    /**
     * 修改应急通讯人员管理
     *
     * @param tEmergencyCrew 应急通讯人员管理
     * @return 结果
     */
    public int updateTEmergencyCrew(TEmergencyCrew tEmergencyCrew);

    /**
     * 批量删除应急通讯人员管理
     *
     * @param communicationIds 需要删除的应急通讯人员管理ID
     * @return 结果
     */
    public int deleteTEmergencyCrewByIds(Long[] communicationIds);

    /**
     * 删除应急通讯人员管理信息
     *
     * @param communicationId 应急通讯人员管理ID
     * @return 结果
     */
    public int deleteTEmergencyCrewById(Long communicationId);
}
