package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TDeviceAlarmInfo;

/**
 * 报警记录Service接口
 * 
 * @author zehong
 * @date 2022-07-04
 */
public interface ITDeviceAlarmInfoService 
{
    /**
     * 查询报警记录
     * 
     * @param alarmId 报警记录ID
     * @return 报警记录
     */
    public TDeviceAlarmInfo selectTDeviceAlarmInfoById(Long alarmId);

    /**
     * 查询报警记录列表
     * 
     * @param tDeviceAlarmInfo 报警记录
     * @return 报警记录集合
     */
    public List<TDeviceAlarmInfo> selectTDeviceAlarmInfoList(TDeviceAlarmInfo tDeviceAlarmInfo);

    /**
     * 新增报警记录
     * 
     * @param tDeviceAlarmInfo 报警记录
     * @return 结果
     */
    public int insertTDeviceAlarmInfo(TDeviceAlarmInfo tDeviceAlarmInfo);

    /**
     * 修改报警记录
     * 
     * @param tDeviceAlarmInfo 报警记录
     * @return 结果
     */
    public int updateTDeviceAlarmInfo(TDeviceAlarmInfo tDeviceAlarmInfo);

    /**
     * 批量删除报警记录
     * 
     * @param alarmIds 需要删除的报警记录ID
     * @return 结果
     */
    public int deleteTDeviceAlarmInfoByIds(Long[] alarmIds);

    /**
     * 删除报警记录信息
     * 
     * @param alarmId 报警记录ID
     * @return 结果
     */
    public int deleteTDeviceAlarmInfoById(Long alarmId);

    /**
     * 报警记录id
     * @return
     */
    public Map<String,Object> selectStatistics();

    /**
     * 预警累计量统计
     * @return
     */
    Map<String,Integer> sumAlarmTotal();
}
