package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TContractorTrainResult;

/**
 * 承包商及访客培训考试结果详情Service接口
 *
 * @author zehong
 * @date 2022-12-27
 */
public interface ITContractorTrainResultService
{
    /**
     * 查询承包商及访客培训考试结果详情
     *
     * @param resultId 承包商及访客培训考试结果详情ID
     * @return 承包商及访客培训考试结果详情
     */
    public TContractorTrainResult selectTContractorTrainResultById(Long resultId);

    /**
     * 查询承包商及访客培训考试结果详情列表
     *
     * @param tContractorTrainResult 承包商及访客培训考试结果详情
     * @return 承包商及访客培训考试结果详情集合
     */
    public List<TContractorTrainResult> selectTContractorTrainResultList(TContractorTrainResult tContractorTrainResult);

    /**
     * 新增承包商及访客培训考试结果详情
     *
     * @param tContractorTrainResult 承包商及访客培训考试结果详情
     * @return 结果
     */
    public int insertTContractorTrainResult(TContractorTrainResult tContractorTrainResult);

    /**
     * 修改承包商及访客培训考试结果详情
     *
     * @param tContractorTrainResult 承包商及访客培训考试结果详情
     * @return 结果
     */
    public int updateTContractorTrainResult(TContractorTrainResult tContractorTrainResult);

    /**
     * 批量删除承包商及访客培训考试结果详情
     *
     * @param resultIds 需要删除的承包商及访客培训考试结果详情ID
     * @return 结果
     */
    public int deleteTContractorTrainResultByIds(Long[] resultIds);

    /**
     * 删除承包商及访客培训考试结果详情信息
     *
     * @param resultId 承包商及访客培训考试结果详情ID
     * @return 结果
     */
    public int deleteTContractorTrainResultById(Long resultId);

    /**
     * 用户课程考试交卷
     * @param tContractorTrainResult
     */
    Map<String,Object> examination(TContractorTrainResult tContractorTrainResult);
}
