package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TContractorTrainResultDetail;

/**
 * 承包商及访客培训考试结果详情Service接口
 * 
 * @author wu
 * @date 2022-12-30
 */
public interface ITContractorTrainResultDetailService 
{
    /**
     * 查询承包商及访客培训考试结果详情
     * 
     * @param detailId 承包商及访客培训考试结果详情ID
     * @return 承包商及访客培训考试结果详情
     */
    public TContractorTrainResultDetail selectTContractorTrainResultDetailById(Long detailId);

    /**
     * 查询承包商及访客培训考试结果详情列表
     * 
     * @param tContractorTrainResultDetail 承包商及访客培训考试结果详情
     * @return 承包商及访客培训考试结果详情集合
     */
    public List<TContractorTrainResultDetail> selectTContractorTrainResultDetailList(TContractorTrainResultDetail tContractorTrainResultDetail);

    /**
     * 新增承包商及访客培训考试结果详情
     * 
     * @param tContractorTrainResultDetail 承包商及访客培训考试结果详情
     * @return 结果
     */
    public int insertTContractorTrainResultDetail(TContractorTrainResultDetail tContractorTrainResultDetail);

    /**
     * 修改承包商及访客培训考试结果详情
     * 
     * @param tContractorTrainResultDetail 承包商及访客培训考试结果详情
     * @return 结果
     */
    public int updateTContractorTrainResultDetail(TContractorTrainResultDetail tContractorTrainResultDetail);

    /**
     * 批量删除承包商及访客培训考试结果详情
     * 
     * @param detailIds 需要删除的承包商及访客培训考试结果详情ID
     * @return 结果
     */
    public int deleteTContractorTrainResultDetailByIds(Long[] detailIds);

    /**
     * 删除承包商及访客培训考试结果详情信息
     * 
     * @param detailId 承包商及访客培训考试结果详情ID
     * @return 结果
     */
    public int deleteTContractorTrainResultDetailById(Long detailId);
}
