package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TContractorTrainCourse;

/**
 * 承包商及访客培训Service接口
 *
 * @author zehong
 * @date 2022-12-27
 */
public interface ITContractorTrainCourseService
{
    /**
     * 查询承包商及访客培训
     *
     * @param contractorCourseId 承包商及访客培训ID
     * @return 承包商及访客培训
     */
    public TContractorTrainCourse selectTContractorTrainCourseById(Long contractorCourseId);

    /**
     * 查询承包商及访客培训列表
     *
     * @param tContractorTrainCourse 承包商及访客培训
     * @return 承包商及访客培训集合
     */
    public List<TContractorTrainCourse> selectTContractorTrainCourseList(TContractorTrainCourse tContractorTrainCourse);

    /**
     * 新增承包商及访客培训
     *
     * @param tContractorTrainCourse 承包商及访客培训
     * @return 结果
     */
    public int insertTContractorTrainCourse(TContractorTrainCourse tContractorTrainCourse);

    /**
     * 修改承包商及访客培训
     *
     * @param tContractorTrainCourse 承包商及访客培训
     * @return 结果
     */
    public int updateTContractorTrainCourse(TContractorTrainCourse tContractorTrainCourse);

    /**
     * 批量删除承包商及访客培训
     *
     * @param contractorCourseIds 需要删除的承包商及访客培训ID
     * @return 结果
     */
    public int deleteTContractorTrainCourseByIds(Long[] contractorCourseIds);

    /**
     * 删除承包商及访客培训信息
     *
     * @param contractorCourseId 承包商及访客培训ID
     * @return 结果
     */
    public int deleteTContractorTrainCourseById(Long contractorCourseId);

    /**
     * 查询承包商及访客培训
     * @param tContractorTrainCourse
     * @return
     */
    TContractorTrainCourse getITContractorTrainCourse(TContractorTrainCourse tContractorTrainCourse);
}
